<?php

defined( 'ABSPATH' ) || exit;

?>
<div id="seoaic-remove-and-reassign-confirm-modal" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title" data-title="<?php esc_html_e('Confirm', 'seoaic');?>"><?php esc_html_e('Confirm', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content fs-18">
            <div id="confirm-modal-content" class="seoaic-modal-content"></div>
            <form id="keyword-delete-and-reassign-confirm-form" class="seoaic-form" method="post" data-callback="">
                <input id="confirm_action" class="seoaic-form-item" type="hidden" name="action" value="">
                <input id="confirm_item_id" class="seoaic-form-item" type="hidden" name="item_id" value="">
                <div class="additional-items dn"></div>
                <div class="mt-20 seoaic-keywords-select-area">
                    <label for="seoaic_reassign_to_keyword"><?php esc_html_e('Select another keyword the child terms will be reassigned to', 'seoaic');?></label>
                    <select required
                            name="reassign_keyword_id"
                            id="seoaic_reassign_to_keyword"
                            class="seoaic-form-item form-select"
                    ></select>
                </div>
                <div class="check text-left seoai-px-0 mt-20">
                    <input type="checkbox"
                           name="remove_sub_items"
                           value="1"
                           class="seoaic-checkbox seoaic-remove-subitems-checkbox seoaic-form-item"
                    >
                    <label for="seoaic-remove-subitems-checkbox" class="label-checkbox"><?php esc_html_e('Remove sub-keywords?', 'seoaic');?></label>
                </div>
            </form>
        </div>
        <div class="seoaic-popup__footer flex-justify">
            <button type="button" class="seoaic-popup__btn-left seoaic-modal-close"><?php esc_html_e('No', 'seoaic');?></button>
            <button type="submit" form="keyword-delete-and-reassign-confirm-form" class="seoaic-popup__btn seoaic-popup__btn-right"><?php esc_html_e('Yes', 'seoaic');?></button>
        </div>
    </div>
</div>
