<?php

defined('ABSPATH') || exit;

?>
<div id="add-keyword-location-language-modal" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3><?php esc_html_e('Set Keyword Location / Language', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content ">
            <form id="set-keyword-country-form" class="seoaic-form" method="post">
                <input type="hidden" name="action" value="seoaic_set_keyword_location" class="seoaic-form-item">
                <input type="hidden" name="post_id" value="" class="seoaic-form-item">
                <div class="keywords-loc-and-lang-wrapper d-flex seoaic-gap-15">
                    <div class="seoaic-popup__field seoaic-w-100">
                        <label class="text-label mb-13"><?php esc_html_e('Location', 'seoaic');?></label>
                        <select name="location" required class="seoaic-form-item form-select"></select>
                    </div>

                    <div class="seoaic-popup__field seoaic-w-100">
                        <label class="text-label mb-13"><?php esc_html_e('Language', 'seoaic');?></label>
                        <select name="language" required class="seoaic-form-item form-select"></select>
                    </div>
                </div>
            </form>
        </div>
        <div class="seoaic-popup__footer">
            <button type="submit"
                    form="set-keyword-country-form"
                    id="btn-set-keyword-country"
                    class="seoaic-popup__btn"
                    data-type="add"
            ><?php esc_html_e('Save', 'seoaic');?></button>
        </div>
    </div>
</div>