<?php

use SEOAIC\collections\prompt_data\KeywordsGeneratePromptDataCollection;
use SEOAIC\keyword_types\KeywordHeadTermType;
use SEOAIC\SEOAIC_PROMPTS;

defined( 'ABSPATH' ) || exit;

global $SEOAIC, $SEOAIC_OPTIONS;

$keywords = $SEOAIC->keywords->getKeywords();

?>

<div id="seoaic-brand-visibility-modal" class="seoaic-modal seoaic-modal-large seoaic-brand-visibility-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3><?php esc_html_e( 'Add Prompts', 'seoaic' ); ?></h3>
        </div>


        <div class="seoaic-popup__content">
            <div class="seoaic-brand-visibility-modal__time-line">
                <ul>
                    <li data-step="1" class="active">
                        <span class="title"><?php esc_html_e( 'Generate Prompts', 'seoaic' ); ?></span>
                    </li>
                    <li data-step="2">
                        <span class="title"><?php esc_html_e( 'Review Prompts', 'seoaic' ); ?></span>
                    </li>
                </ul>
            </div>
            <div class="seoaic-brand-visibility-modal__step active" data-step="1">
                <div class="seoaic-brand-visibility-modal__step-content">
                    <div class="seoaic-brand-visibility-modal__step-form-group">
                        <h3><?php esc_html_e( 'Keywords', 'seoaic' ); ?></h3>
                        <p><?php esc_html_e( 'Select the keywords you\'d like to use to generate your content or add your own.', 'seoaic' ); ?></p>

                        <label>
                            <select id="seoaic-brand-visibility-modal__keywords" name="keywords" multiple></select>
                        </label>

                        <div class="keywords-loc-and-lang-wrapper d-flex seoaic-gap-15 mt-15">
                            <div class="seoaic-popup__field seoaic-w-100">
                                <label class="text-label mb-13"><?php esc_html_e('Location', 'seoaic');?></label>
                                <select id="seoaic-brand-visibility-modal__location" name="location" required class="seoaic-form-item form-select">
                                    <option value="<?php echo $SEOAIC_OPTIONS['seoaic_location']; ?>" selected><?php echo $SEOAIC_OPTIONS['seoaic_location']; ?></option>
                                </select>
                           </div>

                            <div class="seoaic-popup__field seoaic-w-100">
                                <label class="text-label mb-13"><?php esc_html_e('Language', 'seoaic');?></label>
                                <select id="seoaic-brand-visibility-modal__language" name="language" required class="seoaic-form-item form-select" >
                                    <option value="<?php echo $SEOAIC_OPTIONS['seoaic_language']; ?>" selected><?php echo $SEOAIC_OPTIONS['seoaic_language']; ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="seoaic-brand-visibility-modal__step" data-step="2">
                <div class="seoaic-brand-visibility-modal__step-content">
                    <div class="seoaic-brand-visibility-modal__step-form-group">
                        <h3><?php esc_html_e( 'Generated Prompts', 'seoaic' ); ?></h3>
                        <p><?php esc_html_e( 'Edit generated prompts.', 'seoaic' ); ?></p>

                    </div>
                    <table class="seoaic-brand-visibility-modal__step-table-head">
                        <thead>
                            <tr>
                                <th><?php esc_html_e( 'Prompt', 'seoaic' ); ?></th>
                                <th><?php esc_html_e( 'Group', 'seoaic' ); ?></th>
                                <th><?php esc_html_e( 'Actions', 'seoaic' ); ?></th>
                            </tr>
                        </thead>
                    </table>

                    <table class="seoaic-brand-visibility-modal__step-table-body">
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="seoaic-popup__footer flex-justify">
            <button type="button" class="seoaic-popup__btn seoaic-popup__btn-right seoaic-modal-close">
                <?php esc_html_e( 'Cancel', 'seoaic' ); ?>
            </button>

            <div>
                <p class="seoaic-brand-visibility-modal-error-message d-none"></p>
                <button type="button"
                        class="seoaic-popup__btn seoaic-popup__btn-right seoaic-brand-visibility-modal__back-step-btn"
                        disabled >
                    <?php esc_html_e( 'Back', 'seoaic' ); ?>
                </button>
                <button type="button"
                        class="seoaic-popup__btn seoaic-popup__btn-right seoaic-brand-visibility-modal__next-step-btn"
                        disabled >
                    <?php esc_html_e( 'Next', 'seoaic' ); ?>
                </button>
            </div>
        </div>
    </div>
</div>