<?php

use SEOAIC\collections\prompt_data\KeywordsGeneratePromptDataCollection;
use SEOAIC\keyword_types\KeywordHeadTermType;
use SEOAIC\SEOAIC_PROMPTS;

defined( 'ABSPATH' ) || exit;

global $SEOAIC, $SEOAIC_OPTIONS;

$keywords = $SEOAIC->keywords->getKeywords();

?>

<div id="seoaic-brand-visibility-manual-prompts-generate-modal" class="seoaic-modal seoaic-modal-large seoaic-brand-visibility-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3><?php esc_html_e( 'Add Prompts', 'seoaic' ); ?></h3>
        </div>


        <div class="seoaic-popup__content">
            <div class="seoaic-brand-visibility-modal__step-form-group">
                <h3><?php esc_html_e( 'Generated Prompts', 'seoaic' ); ?></h3>
                <p><?php esc_html_e( 'Add your own prompts.', 'seoaic' ); ?></p>
            </div>

            <div class="keywords-loc-and-lang-wrapper d-flex seoaic-gap-15 mt-15 mb-13">
                <div class="seoaic-popup__field seoaic-w-100 d-flex flex-column">
                    <label class="text-label mb-13"><?php esc_html_e('Location', 'seoaic');?></label>
                    <select name="location" required class="seoaic-form-item form-select seoaic-brand-visibility-modal__location">
                        <option value="<?php echo $SEOAIC_OPTIONS['seoaic_location']; ?>" selected><?php echo $SEOAIC_OPTIONS['seoaic_location']; ?></option>
                    </select>
                </div>

                <div class="seoaic-popup__field seoaic-w-100 d-flex flex-column">
                    <label class="text-label mb-13"><?php esc_html_e('Language', 'seoaic');?></label>
                    <select name="language" required class="seoaic-form-item form-select seoaic-brand-visibility-modal__language" >
                        <option value="<?php echo $SEOAIC_OPTIONS['seoaic_language']; ?>" selected><?php echo $SEOAIC_OPTIONS['seoaic_language']; ?></option>
                    </select>
                </div>
            </div>

            <table class="seoaic-brand-visibility-modal__step-table-head">
                <thead>
                    <tr>
                        <th><?php esc_html_e( 'Prompt', 'seoaic' ); ?></th>
                        <th><?php esc_html_e( 'Actions', 'seoaic' ); ?></th>
                    </tr>
                </thead>
            </table>

            <table class="seoaic-brand-visibility-modal__step-table-body">
                <tbody>

                </tbody>
            </table>

            <div class="seoaic-brand-visibility-modal__step-prompts_editor">
                <input type="text" placeholder="<?php esc_html_e( 'Write your prompt', 'seoaic' ); ?> ... ">
                <button type="button" class="seoaic-popup__btn seoaic-add-new-prompt-button " disabled><?php esc_html_e( 'Add', 'seoaic' ); ?></button>
            </div>

        </div>

        <div class="seoaic-popup__footer flex-justify">
            <button type="button" class="seoaic-popup__btn seoaic-popup__btn-right seoaic-modal-close">
                <?php esc_html_e( 'Cancel', 'seoaic' ); ?>
            </button>

            <button type="button"
                    class="seoaic-popup__btn seoaic-popup__btn-right submit-prompts-button" disabled>
                <?php esc_html_e( 'Save', 'seoaic' ); ?>
            </button>
        </div>
    </div>
</div>