<?php

defined('ABSPATH') || exit;

use SEOAIC\collections\prompt_data\IdeasGeneratePromptDataCollection;
use SEOAIC\SEOAIC;
use SEOAIC\SEOAIC_PROMPTS;
use SEOAIC\SEOAIC_SETTINGS;
use SEOAIC\Wizard;

global $SEOAIC_OPTIONS, $SEOAIC;

$search_engine = isset($_GET['search_engine']) ? $_GET['search_engine'] : 'google';
$rank_tracker_page = isset($_GET['page']) && $_GET['page'] == 'seoaic-rank-tracker' ? true : false;
$wizard_page = isset($_GET['page']) && $_GET['page'] == 'seoaic-onboarding-wizard' ? true : false;
$label = esc_html__('Choose keywords', 'seoaic');
$selected_keywords_slugs = [];
$isInternalLinksEnabled = SEOAIC_SETTINGS::isGenerateInternalLinksEnabled();
$isPillarLinksEnabled = SEOAIC_SETTINGS::isAddPillarLinksEnabled();
$pillarLinksOptionsString = '';

if ($isPillarLinksEnabled) {
    $pillarLinks = $SEOAIC->pillar_links->getPillarLinks();
    $pillarLinksOptionsString = $SEOAIC->pillar_links->makePillarLinksOptionsString($pillarLinks);
}

if ($rank_tracker_page) {
    $keywords = !empty($SEOAIC_OPTIONS['search_terms'][$search_engine]) ? $SEOAIC_OPTIONS['search_terms'][$search_engine] : [];
    $label = esc_html__('Choose search terms', 'seoaic');

} elseif ($wizard_page) {
    $keywords = get_transient(Wizard::FIELD_KEYWORDS);
    $keywords = false !== $keywords ? $keywords : [];
    $keywords = json_decode(json_encode($keywords), true);
    $selected_keywords = get_transient(Wizard::FIELD_SELECTED_KEYWORDS);
    $selected_keywords = false !== $selected_keywords ? $selected_keywords : [];
    $selected_keywords = json_decode(json_encode($selected_keywords));
    $selected_keywords_slugs = array_map(function ($item) {
        return $item->slug;
    }, $selected_keywords);

} else {
    $keywords = $SEOAIC->keywords->getKeywords();
}


?>
<div id="generate-ideas-new-keywords" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3><?php esc_html_e('Generate Ideas', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content position-relative">
            <?php
            (new SEOAIC_PROMPTS())->makePromptsSection((new IdeasGeneratePromptDataCollection()), true);
            ?>
            <form id="generate-idea-form-new" class="seoaic-form" method="post" data-callback="window_reload">
                <input class="seoaic-form-item" type="hidden" name="action" value="seoaic_generate_ideas_new_keywords">
                <p class="seoaic-popup__description">
                    <?php esc_html_e('This option is useful when there is a need to generate multiple posts at once, either for immediate publishing or for scheduling them over a specific period. It streamlines the process of generating a significant amount of content efficiently.', 'seoaic');?>
                </p>
                <div class="seoaic-popup__field">
                    <label class="text-label"><?php esc_html_e('How many ideas do you want to generate?', 'seoaic');?></label>
                    <input type="number" name="ideas_count" value="10" min="1" class="seoaic-form-item">
                </div>
                <div class="seoaic-popup__field">
                    <label class="text-label mb-10"><?php esc_html_e('Idea type', 'seoaic');?></label>
                    <select name="idea_template_type" class="seoaic-form-item form-select">
                        <?php
                        foreach (seoaic_get_prompt_template_types() as $key => $template_type) {
                            ?>
                            <option value="<?php echo esc_attr($key);?>"><?php echo esc_html($template_type);?></option>
                            <?php
                        }
                        ?>
                    </select>
                </div>
                <div class="seoaic-popup__field d-none">
                    <div class="inner select-clusters-inner-block loading">
                        <label class="mb-5"><?php _e('Selected clusters', 'seoaic'); ?></label>
                        <select id="seoaic-idea-select-selected_clusters" name="selected_cluster"
                                class="clusters seoaic-form-item form-select allowClearTrue"
                                data-placeholder="<?php _e('Not Selected', 'seoaic'); ?>">
                            <option></option>
                        </select>
                    </div>
                </div>
                <div class="seoaic-popup__field">
                    <div class="top label-keyword">
                        <label class="mb-10 mt-20 text-label"><?php echo esc_html($label);?></label>
                        <a href="<?php echo esc_url(admin_url('admin.php?page=seoaic-keywords'));?>"
                           class="link-keywords"><?php esc_html_e('Open the keywords table', 'seoaic');?>
                        </a>
                    </div>

                    <?php
                    if ($wizard_page) {
                        ?>
                        <select name="select-keywords" multiple="multiple" class="seoaic-form-item" data-wizard="1">
                        <?php
                    } else {
                        ?>
                        <select name="select-keywords" multiple="multiple" class="seoaic-form-item">
                        <?php
                    }

                        if ($rank_tracker_page) {
                            foreach ($keywords as $keyword) {
                                echo '<option value="' . esc_attr($keyword['slug']) . '">' . esc_html($keyword['keyword']) . '</option>';
                            }

                        } elseif ($wizard_page) {
                            foreach ($keywords as $keyword) {
                                $selected = in_array($keyword['slug'], $selected_keywords_slugs) ? ' selected' : '';
                                echo '<option value="' . esc_attr($keyword['slug']) . '"' . esc_attr($selected) . '>' . esc_html($keyword['name']) . '</option>';
                            }

                        } else {
                            foreach ($keywords as $keyword) {
                                echo '<option value="' . esc_attr($keyword['id']) . '">' . esc_html($keyword['name']) . '</option>';
                            }
                        }
                        ?>
                    </select>
                    <div class="d-flex mt-15">
                        <?php
                        if ($rank_tracker_page) {
                            ?>
                            <input type="hidden" name="search_terms_page" value="true" class="seoaic-form-item">
                            <?php
                        }

                        if ($keywords) {
                            ?>
                            <div class="all-selector check mr-15">
                                <input type="checkbox" name="select_all_checkbox" id="select_all_checkbox" value="value">
                                <label for="select_all_checkbox"><?php esc_html_e('Select all', 'seoaic');?></label>
                            </div>
                            <?php
                        }
                        ?>
                        <div class="check generate_separately_wrap">
                            <input type="checkbox" name="generate_keywords_separately" class="seoaic-form-item" id="generate_keywords_separately" value="generate">
                            <label for="generate_keywords_separately"><?php esc_html_e('Generate separately', 'seoaic');?></label>
                        </div>
                    </div>
                </div>

                <?php
                if (
                    !$rank_tracker_page
                    && $isInternalLinksEnabled
                ) {
                    ?>
                    <div class="seoaic-popup__field">
                        <label class="mb-10 mt-20 text-label"><?php echo esc_html_e("Internal links", "seoaic");?></label>
                        <select
                            name="internal_links"
                            multiple="multiple"
                            class="seoaic-form-item form-select soaic-idea-internal-links"
                        ></select>
                        <div class="d-flex gap-15">
                            <a href="#"
                                class="internal-links-add-recommended small dn"
                                title="<?php esc_attr_e("Select up to 5 linked and related posts", "seoaic");?>"
                            ><?php esc_html_e("Add recommended", "seoaic");?></a>
                            <a href="#"
                                class="internal-links-load-random small d-flex"
                                title="<?php esc_attr_e("Load random posts and articles, and pre-select 5 of them. With multilang plugin enabled the results are based on the selected Language", "seoaic");?>"
                            ><?php esc_html_e("Random Posts", "seoaic");?></a>
                        </div>
                    </div>
                    <?php
                }

                if (
                    !$rank_tracker_page
                    && $isPillarLinksEnabled
                ) {
                    ?>
                    <div class="seoaic-popup__field">
                        <label class="mb-10 mt-20 text-label"><?php echo esc_html_e("Pillar links", "seoaic");?></label>
                        <select
                            name="pillar_links"
                            multiple="multiple"
                            class="seoaic-form-item form-select soaic-idea-pillar-links"
                        ><?php echo wp_kses(
                            $pillarLinksOptionsString,
                            [
                                'option' => [
                                    'value'         => [],
                                    'data-lang'     => [],
                                    'data-locale'   => [],
                                ],
                            ]
                        );?></select>
                        <div class="d-flex gap-15">
                            <a href="#"
                                class="pillar-links-select-random small d-flex"
                                title="<?php esc_attr_e("Select random pillar links. With multilang plugin enabled the results are based on the selected Language.", "seoaic");?>"
                            ><?php esc_html_e("Random", "seoaic");?></a>
                        </div>
                    </div>
                    <?php
                }
                ?>

                <div class="seoaic-popup__field">
                    <input type="hidden" name="selected_keywords" value="" class="seoaic-form-item">
                    <?php echo \SEOAIC\SEOAIC_SETTINGS::createRepeaterHTML('seoaic_services', true) ?>
                    <?php echo \SEOAIC\SEOAIC_SETTINGS::createRepeaterHTML('seoaic_target_audience', true) ?>
                    <?php echo \SEOAIC_LOCATIONS::seoaicSelectLocationGroup() ?>
                </div>
                <div class="seoaic-popup__field">
                    <label class="text-label"><?php esc_html_e('Custom prompt', 'seoaic');?></label>
                    <textarea name="idea_prompt" class="seoaic-form-item"></textarea>
                </div>

                <?php echo $SEOAIC->multilang->get_multilang_checkboxes();?>

            </form>
        </div>
        <div class="seoaic-popup__footer flex-right">
            <button id="btn-generate-ideas" type="submit" form="generate-idea-form-new" class="seoaic-popup__btn">
                <?php esc_html_e('Generate Ideas', 'seoaic');?>
            </button>
        </div>
    </div>
</div>
