<?php
defined( 'ABSPATH' ) || exit;
use SEOAIC\SEOAIC;

global $SEOAIC;

$config         = $SEOAIC->brand_visibility->getConfig();
$competitors    = $config['data']['brand_tracking_competitors'] ?? [];
$main_brand     = $config['data']['brand_tracking_main_branding_words'] ?? [];
?>


<div id="seoaic-brand-visibility-competitor-modal" class="seoaic-modal seoaic-modal-large seoaic-brand-visibility-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3><?php esc_html_e( 'Setup Brands', 'seoaic' ); ?></h3>
        </div>


        <div class="seoaic-popup__content brand-visibility-row">
           <div class="brand-visibility-col-6 brand-visibility-competitors-editor">
               <div class="seoaic-brand-visibility-modal__step-form-group">
                   <h3><?php esc_html_e( 'Competitors', 'seoaic' ); ?></h3>
               </div>

               <table class="seoaic-brand-visibility-modal__step-table-head">
                   <thead>
                   <tr>
                       <th><?php esc_html_e( 'Competitor', 'seoaic' ); ?></th>
                       <th><?php esc_html_e( 'Actions', 'seoaic' ); ?></th>
                   </tr>
                   </thead>
               </table>

               <table class="seoaic-brand-visibility-modal__step-table-body">
                   <tbody>
                       <?php if ( $competitors ): ?>
                           <?php foreach ( $competitors as $competitor ): ?>
                               <tr style="">
                                   <td class="competitor-name"><?php echo esc_html( $competitor ) ?></td>
                                   <td>
                                       <button type="button" class="seoaic-edit"></button>
                                       <button type="button" class="seoaic-remove"></button>
                                   </td>
                               </tr>
                           <?php endforeach;?>
                       <?php endif;?>
                   </tbody>
               </table>

               <div class="seoaic-brand-visibility-modal__step-prompts_editor">
                   <input type="text" name="competitor_name"  placeholder="<?php esc_html_e( 'Competitor Name', 'seoaic' ); ?> ... ">
                   <button type="button" class="seoaic-popup__btn  seoaic-add-new-competitor-button " disabled><?php esc_html_e( 'Add', 'seoaic' ); ?></button>
               </div>
           </div>
            <div class="brand-visibility-col-6 brand-visibility-brands-editor">
                <div class="seoaic-brand-visibility-modal__step-form-group">
                    <h3><?php esc_html_e( 'Brand Word', 'seoaic' ); ?></h3>
                </div>

                <table class="seoaic-brand-visibility-modal__step-table-head">
                    <thead>
                    <tr>
                        <th><?php esc_html_e( 'Brand', 'seoaic' ); ?></th>
                        <th><?php esc_html_e( 'Actions', 'seoaic' ); ?></th>
                    </tr>
                    </thead>
                </table>

                <table class="seoaic-brand-visibility-modal__step-table-body">
                    <tbody>
                        <?php if ( $main_brand ): ?>
                            <?php foreach ( $main_brand as $brand ): ?>
                                <tr style="">
                                    <td class="brand-name"><?php echo esc_html( $brand ) ?></td>
                                    <td>
                                        <button type="button" class="seoaic-edit"></button>
                                        <button type="button" class="seoaic-remove"></button>
                                    </td>
                                </tr>
                            <?php endforeach;?>
                        <?php endif;?>
                    </tbody>
                </table>

                <div class="seoaic-brand-visibility-modal__step-prompts_editor">
                    <input type="text" name="brand-name"  placeholder="<?php esc_html_e( 'Brand Word', 'seoaic' ); ?> ... ">
                    <button type="button" class="seoaic-popup__btn seoaic-add-new-brand-button" disabled><?php esc_html_e( 'Add', 'seoaic' ); ?></button>
                </div>
            </div>
        </div>

        <div class="seoaic-popup__footer flex-justify">
            <button type="button" class="seoaic-popup__btn seoaic-popup__btn-right seoaic-modal-close">
                <?php esc_html_e( 'Cancel', 'seoaic' ); ?>
            </button>

            <button type="button"
                    class="seoaic-popup__btn seoaic-popup__btn-right submit-competitors-button" disabled>
                <?php esc_html_e( 'Save', 'seoaic' ); ?>
            </button>
        </div>
    </div>
</div>