<?php

defined( 'ABSPATH' ) || exit;

global $SEOAIC_OPTIONS;

$gsc_url = !empty($SEOAIC_OPTIONS['seoaic_gsc_url']) ? esc_url($SEOAIC_OPTIONS['seoaic_gsc_url']) : get_home_url();
?>
<div id="seoaic-content-improvement-scan-modal" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title" data-title="<?php esc_html_e('Google Search Console', 'seoaic');?>"><?php esc_html_e('Google Search Console', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content fs-18">
            <div id="confirm-modal-content" class="seoaic-modal-content">
                <p><?php esc_html_e('This feature allows users to integrate their website with Google Search Console to enhance SEO reporting. Once connected, users gain access to key metrics such as clicks, impressions, and average position directly within their dashboard. Site ownership can be verified using multiple methods: the Classic method, a DNS TXT record, or a DNS CNAME record.', 'seoaic');?></p>
            </div>
            <div class="seoai-gsc-url_block">
                <label for="seoai-gsc-url"><?php esc_html_e('Link for Google integration. You can edit it here or update it later in the settings.', 'seoaic') ?></label>
                <input type="url" id="seoai-gsc-url" name="seoaic_gsc_url" class="form-input light" value="<?php echo esc_url($gsc_url) ?>">
            </div>

            <div class="seoai-gsc-url_block">
                <label for="seoai-gsc-url"><?php esc_html_e('Select a verification method', 'seoaic') ?></label>
                <div class="toggle-choose-role">
                    <div class="checkbox-list">
                        <div class="wrapper">
                            <div class="checkbox-wrapper-mc">
                                <input id="verification-method-meta"
                                    class="seoaic-form-item"
                                    name="verification_method" type="radio"
                                    value="meta"
                                    checked
                                >
                                <label for="verification-method-meta" class="check">
                                    <svg width="18px" height="18px" viewBox="0 0 18 18">
                                        <path d="M1,9 L1,3.5 C1,2 2,1 3.5,1 L14.5,1 C16,1 17,2 17,3.5 L17,14.5 C17,16 16,17 14.5,17 L3.5,17 C2,17 1,16 1,14.5 L1,9 Z"></path>
                                        <polyline points="1 9 7 14 15 4"></polyline>
                                    </svg>
                                    <span><?php esc_html_e('Classic method', 'seoaic') ?></span>
                                </label>
                            </div>

                            <div class="dns-integration">
                                <label><?php esc_html_e('DNS integration') ?></label>
                                <div class="dns-integration-wrap">
                                    <div class="checkbox-wrapper-mc">
                                        <input id="verification-method-dns"
                                            class="seoaic-form-item"
                                            name="verification_method" type="radio"
                                            value="dns_txt">
                                        <label for="verification-method-dns" class="check">
                                            <svg width="18px" height="18px" viewBox="0 0 18 18">
                                                <path d="M1,9 L1,3.5 C1,2 2,1 3.5,1 L14.5,1 C16,1 17,2 17,3.5 L17,14.5 C17,16 16,17 14.5,17 L3.5,17 C2,17 1,16 1,14.5 L1,9 Z"></path>
                                                <polyline points="1 9 7 14 15 4"></polyline>
                                            </svg>
                                            <span><?php esc_html_e('DNS TXT record', 'seoaic') ?></span>
                                        </label>
                                    </div>
                                    <div class="checkbox-wrapper-mc">
                                        <input id="verification-method-cname"
                                            class="seoaic-form-item"
                                            name="verification_method" type="radio"
                                            value="dns_cname">
                                        <label for="verification-method-cname" class="check">
                                            <svg width="18px" height="18px" viewBox="0 0 18 18">
                                                <path d="M1,9 L1,3.5 C1,2 2,1 3.5,1 L14.5,1 C16,1 17,2 17,3.5 L17,14.5 C17,16 16,17 14.5,17 L3.5,17 C2,17 1,16 1,14.5 L1,9 Z"></path>
                                                <polyline points="1 9 7 14 15 4"></polyline>
                                            </svg>
                                            <span><?php esc_html_e('DNS CNAME record', 'seoaic') ?></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="seoaic-popup__footer flex-right">
            <button type="button" class="seoaic-cansel-btn content-improvement-scan seoaic-modal-close" data-scan="no"><?php esc_html_e('Decline', 'seoaic') ?></button>
            <button type="button" class="seoaic-popup__btn seoaic-popup__btn-right seoaic-modal-close content-improvement-scan" data-scan="yes"><?php esc_html_e('Okay', 'seoaic');?></button>
        </div>
    </div>
</div>
