<?php

defined( 'ABSPATH' ) || exit;

global $SEOAIC_OPTIONS;

$gsc_url = !empty($SEOAIC_OPTIONS['seoaic_gsc_url']) ? esc_url($SEOAIC_OPTIONS['seoaic_gsc_url']) : get_home_url();
$parsedUrl = parse_url($gsc_url);
$domain = $parsedUrl['host'];
?>
<div id="seoaic-content-improvement-dns-txt-integration-modal" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title" data-title="<?php esc_html_e('DNS integration', 'seoaic');?>"><?php esc_html_e('DNS integration', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content fs-18">
            <div class="seoaic-popup__content__header"></div>
            <div id="confirm-modal-content" class="seoaic-modal-content"><h4><?php esc_html_e('Add a DNS record to your domain configuration.', 'seoaic');?></h4></div>
            <div class="seoaic-dns-integration">
                <ul>
                    <li><?php esc_html_e('Log in to your Domain Name System account', 'seoaic');?></li>
                    <li><?php esc_html_e('Add the following TXT record to your DNS configuration for your domain', 'seoaic');?> <span class="seoaic-dns-domain-name"><?php echo esc_html($domain); ?></span></li>
                    <li><?php esc_html_e('Save changes', 'seoaic');?></li>
                </ul>
                <div class="seoaic-dns-integration-value-container copy-wrapper">
                    <input type="text" class="seoaic-dns-integration-value" readonly value="">
                    <button class="copy_to_clipboard"><span class="dashicons dashicons-admin-page"></span></button>
                </div>
                <blockquote><?php esc_html_e('Note: Changes to DNS settings usually don\'t show up in Search Console immediately. This can take up to a day.', 'seoaic'); ?></blockquote>
            </div>
        </div>
        <div class="seoaic-popup__footer flex-right">
            <button type="button" class="seoaic-popup__btn seoaic-modal-close"><?php esc_html_e('Close', 'seoaic') ?></button>
        </div>
    </div>
</div>
