<?php

defined('ABSPATH') || exit;

?>
<div id="competitors-compare" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup competitors-compare">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3><?php esc_html_e('Competitors Compare', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content">
            <input type="checkbox" id="seoaic-display-compare-columns" class="d-none">
            <label for="seoaic-display-compare-columns" class="seoaic-button-small position-relative"><?php esc_html_e('Display columns', 'seoaic');?></label>
            <div class="seoaic-columns-selector-view"></div>
            <div class="table">
                <div class="body overflow-x-hidden"></div>
            </div>
        </div>
        <div class="seoaic-popup__footer">
            <button type="button"
                    class="seoaic-popup__btn load-more-terms"
                    data-loading="<?php esc_html_e('LOADING', 'seoaic');?>"
                    data-loaded="<?php esc_html_e('LOAD MORE', 'seoaic');?>">
                <?php esc_html_e('LOAD MORE', 'seoaic');?>
            </button>
        </div>
    </div>
</div>