<?php

defined('ABSPATH') || exit;

$now_utc = new DateTime('now', new DateTimeZone('UTC'));
$status_date = esc_attr($now_utc->format('Y-m-d\TH:i'));
?>
<div id="seoaic_calendar-posts-modal" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3><?php esc_html_e('Reschedule posts', 'seoaic'); ?></h3>
        </div>
        <div class="seoaic-popup__content fs-18">
            <div class="seoaic-modal-content"></div>
            <form id="schedule-posts-form" class="seoaic-form" method="post" data-callback="window_reload">
                <div class="additional-items" style="display: none"></div>
                    <div class="form-reschedule-post-details"></div>
                    <div class="seoaic-nav-events-buttons">
                        <a href="#" id="seoiac_prevEventBtn" class="seoaic-button-small position-relative"><?php esc_html_e('← Previous', 'seoaic'); ?></a>
                        <a href="#" id="seoiac_nextEventBtn" class="seoaic-button-small position-relative"><?php esc_html_e('Next →', 'seoaic'); ?></a>
                    </div>
                <div class="seoaic-popup__field form-reschedule-calendar-input">
                        <label class="text-label"><?php esc_html_e('Generated Post Preview', 'seoaic'); ?></label>
                        <div id="seoaic-calendar-modal-editor">
                            <?php
                            $content = '';
                            $editor_id = 'seoaic-calendar-post-editor';
                            $settings = array(
                                'textarea_name' => 'custom_post_content',
                                'editor_height' => 400,
                                'media_buttons' => true,
                                'tinymce' => array(
                                    'toolbar1' => 'bold italic underline | bullist numlist | link unlink | undo redo',
                                    'toolbar2' => '',
                                    'menubar' => false,
                                    'statusbar' => false,
                                )
                            );
                            wp_editor($content, $editor_id, $settings);
                            ?>
                        </div>
                        <div id="seoaic-calendar-modal-editor_controls"></div>
                    <label class="text-label d-none"><?php esc_html_e('Reschedule date', 'seoaic'); ?></label>
                    <div class="seoaic-date-picker d-none">
                        <input type="text" id="reschedule_posting_date" name="reschedule_posting_date"
                               value="<?php echo esc_attr(date('Y-m-d')); ?>" class="mt-0 seoaic-form-item">
                        <div class="picker-call"></div>
                    </div>
                </div>
                <div class="seoaic-popup__field">
                    <label class="text-label"><?php esc_html_e('Change selected posts status to:', 'seoaic'); ?></label>
                    <div class="status_buttons">
                        <ul class="post-status-dd-menu">
                            <li title="Change to: Published"
                                class="seoaic-posts-new-status post-status post-status--publish seoaic-ajax-submit seoaic-ajax-form seoaic-modal-close" data-status="publish">
                                <?php esc_html_e('Published', 'seoaic'); ?>
                                <input type="hidden" name="action" class="seoaic-ajax-field" value="seoaic_reschedule_posts">
                                <input type="hidden" name="selected_posts" class="seoaic-ajax-field" value="">
                                <input type="hidden" name="new_status" class="seoaic-ajax-field" value="publish">
                                <input type="hidden" name="reschedule_posting_date_UTC" class="seoaic-ajax-field" value="<?php echo esc_attr($status_date)?>">
                            </li>
                            <li title="Change to: Draft" class="seoaic-posts-new-status post-status post-status--draft seoaic-ajax-submit seoaic-ajax-form seoaic-modal-close"
                                data-status="draft"><?php esc_html_e('Draft', 'seoaic'); ?>
                                <input type="hidden" name="action" class="seoaic-ajax-field" value="seoaic_reschedule_posts">
                                <input type="hidden" name="selected_posts" class="seoaic-ajax-field" value="">
                                <input type="hidden" name="new_status" class="seoaic-ajax-field" value="draft">
                                <input type="hidden" name="reschedule_posting_date_UTC" class="seoaic-ajax-field" value="<?php echo esc_attr($status_date)?>">
                            </li>
                        </ul>
                    </div>
                </div>
            </form>
        </div>
        <div class="seoaic-popup__footer flex-justify">
            <button type="button"
                    class="seoaic-popup__btn-left seoaic-modal-close"><?php esc_html_e('No', 'seoaic'); ?></button>
            <button type="button"
                    class="seoaic-popup__btn-right seoaic-popup__btn seoaic-modal-close"><?php esc_html_e('Close', 'seoaic'); ?></button>
        </div>
    </div>
</div>