<?php

defined('ABSPATH') || exit;
global $SEOAIC;

?>
<div id="seoaic-also-ask-generate-ideas" class="seoaic-modal seoaic-fixed-scroll-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title"
                data-title="<?php esc_attr_e('Also ask generate ideas', 'seoaic'); ?>"><?php esc_html_e('Review posts and ideas', 'seoaic'); ?></h3>
        </div>
        <div class="seoaic-popup__content fs-18">
            <div class="seoaic-top-actions-on-ideas d-none">
                <label id="seoaic-select-all-also-ask-ideas" class="accent accent-underline"><?php esc_html_e('Select all', 'seoaic'); ?></label>
            </div>
            <div class="seoaic-modal-content" data-language="<?php echo esc_attr(\SEOAIC\SEOAIC_SETTINGS::getLanguage()); ?>" data-location="<?php echo esc_attr(\SEOAIC\SEOAIC_SETTINGS::getLocation()); ?>">
                <div class="seoaic-scroll-vertical seoaic-created-ob-ideas"></div>
            </div>
            <div class="d-none"><?php echo $SEOAIC->multilang->get_multilang_checkboxes(); ?></div>
        </div>
        <div class="seoaic-popup__footer flex-right seoaic-flex-wrap ai-center seoaic-top-border-light">
            <?php echo $SEOAIC->onboarding->get_mass_generate_selections(); ?>
            <button disabled type="button"
                    class="seoaic-accept-selected-also-ask-ideas seoaic-branded-button small-button mr-15"
                    data-accepting="<?php esc_html_e('Accepting', 'seoaic'); ?>"
                    data-default="<?php esc_html_e('Accept ideas', 'seoaic'); ?>">
                <span class="button-text"><?php esc_html_e('Accept ideas', 'seoaic'); ?></span>
                (<span class="button-value">0</span>)
            </button>
            <button disabled type="button"
                    class="seoaic-try-remove-selected-ob-ideas seoaic-branded-button small-button"
                    data-removing="<?php esc_html_e('Removing', 'seoaic'); ?>"
                    data-default="<?php esc_html_e('Remove', 'seoaic'); ?>"><?php esc_html_e('Remove', 'seoaic'); ?></button>
            <button disabled type="button"
                    class="seoaic-accept-selected-ob-ideas seoaic-branded-button small-button ml-10"
                    data-accepting="<?php esc_html_e('Accepting', 'seoaic'); ?>"
                    data-default="<?php esc_html_e('Accept', 'seoaic'); ?>"><?php esc_html_e('Accept', 'seoaic'); ?></button>
            <button disabled type="button"
                    class="seoaic-generated-selected-ob-ideas seoaic-branded-button small-button ml-10"><?php esc_html_e('Generate selected', 'seoaic'); ?></button>
            <button data-idea-id="0"
                    class="seoaic_edit_meta_settings seoaic_edit_meta_settings_mass dashicons dashicons-admin-generic ml-10"
                    type="button"></button>
            <div class="total-also-ask-ideas-selected ml-auto fs-small">
                <span><?php echo esc_html('0'); ?></span><?php esc_html_e(' selected', 'seoaic'); ?>
            </div>
            <div class="total-also-ask-ideas-total ml-15 fs-small">
                <span><?php echo esc_html('0'); ?></span><?php esc_html_e(' total items', 'seoaic'); ?>
            </div>
            <button type="button"
                    class="seoaic-popup__btn seoaic-popup__btn-right ml-auto seoaic-modal-close seoaic-branded-button small-button outline d-flex ai-center"><?php esc_html_e('Close', 'seoaic'); ?></button>
        </div>
        <div class="seoaic-on-action-attention-remove d-none">
            <div class="seoaic-on-action-attention-remove-message">
                <?php esc_html_e('Are you sure you want to remove those items?', 'seoaic'); ?>
            </div>
            <button type="button"
                    class="seoaic-remove-selected-ob-ideas seoaic-on-action-attention-remove-button seoaic-branded-button small-button ml-15"><?php esc_html_e('Yes', 'seoaic'); ?></button>
            <button type="button"
                    class="seoaic-on-action-attention-remove-close seoaic-on-action-attention-remove-button seoaic-branded-button small-button ml-10"><?php esc_html_e('No', 'seoaic'); ?></button>
        </div>
        <div class="seoaic-loader-container" id="seoaic_saving_also_ask_ideas_progress"
             style="<?php echo esc_attr('display:none') ?>">
            <h3 class="loader-text seoaic-loading-label accent seoaic-text-nowrap"><?php _e('Accepting ideas ', 'seoaic'); ?>
                <span class="loader-value-percentage" data-progress="0"><?php _e('0%', 'seoaic'); ?></span></h3>
            <div class="seoaic-progress-bar seoaic-ml-20"><span style="width: 0"></span></div>
        </div>
    </div>
</div>