<?php

defined( 'ABSPATH' ) || exit;

?>
<div id="seoaic-create-redirects" class="seoaic-modal seoaic-modal-large seoaic-create-redirects-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title"><?php esc_html_e( 'Add Redirects', 'seoaic' ); ?></h3>
        </div>
        <div class="seoaic-popup__content">
            <table class="redirects-posts-table" border="1" cellspacing="0" cellpadding="5">
                <thead>
                <tr>
                    <th><?php esc_html_e( 'Page from', 'seoaic' ); ?></th>
                    <th><?php esc_html_e( 'Redirect to', 'seoaic' ); ?></th>
                    <th><?php esc_html_e( 'Action', 'seoaic' ); ?></th>
                </tr>
                </thead>
            </table>
            <div class="redirects-table">
                <table class="redirects-posts-table" border="1" cellspacing="0" cellpadding="5" id="redirects-posts-table">
                    <tbody></tbody>
                </table>
            </div>
            <div class="redirect-editor">
                <div class="redirect-editor-column editor-column-create-redirect-from dn" >
                    <select id="seoaic-multiply-create-redirect-from" class="seoaic-form-item form-select"></select>
                </div>

                <div class="redirect-editor-column editor-column-create-redirect-from">
                    <select id="seoaic-create-redirect-from" class="seoaic-form-item form-select"></select>
                </div>
                <div class="redirect-editor-column editor-column-create-redirect-to">
                    <select id="seoaic-create-redirect-to" class="seoaic-form-item form-select"></select>
                </div>
                <button class="seoaic-popup__btn" id="redirect-editor-add-redirect-button" disabled><?php esc_html_e('Add', 'seoaic');?></button>
            </div>
            <div class="redirect-editor">
                <div class="seoaic-create-redirect-type-group">
                    <input type="radio" id="seoaic-create-redirect-single" name="seoaic-create-redirect-multiply" value="single" checked>
                    <label for="seoaic-create-redirect-single"><?php esc_html_e('Single', 'seoaic');?></label>
                    <input type="radio" id="seoaic-create-redirect-multiply" name="seoaic-create-redirect-multiply" value="multiply" >
                    <label for="seoaic-create-redirect-multiply"><?php esc_html_e('Multiple', 'seoaic');?></label>

                    <div class="mr-15"></div>

                    <input type="radio" id="seoaic-create-redirect-301" name="seoaic-create-redirect-type" value="301" checked>
                    <label for="seoaic-create-redirect-301"><?php esc_html_e('301 redirect', 'seoaic');?></label>
                    <input type="radio" id="seoaic-create-redirect-410" name="seoaic-create-redirect-type" value="410">
                    <label for="seoaic-create-redirect-410"><?php esc_html_e('410 redirect', 'seoaic');?></label>
                </div>
            </div>
        </div>
        <div class="seoaic-popup__footer flex-right">
            <button type="button" class="seoaic-popup__btn seoaic-popup__btn-right mr-15 seoaic-modal-close">
                <?php esc_html_e( 'Close', 'seoaic' ); ?>
            </button>
            <button type="button" class="seoaic-popup__btn seoaic-popup__btn-right" id="seoaic-apply-redirects-button" disabled>
                <?php esc_html_e( 'Apply redirects', 'seoaic' ); ?>
            </button>
        </div>
    </div>
</div>
