<?php

global $SEOAIC,$SEOAIC_OPTIONS;

defined('ABSPATH') || exit;

$locations = seoaic_google_ads_available_locations();
$selected_location = !empty($SEOAIC_OPTIONS['seoaic_location']) ? $SEOAIC_OPTIONS['seoaic_location'] : 'United States';

?>
<div id="seoaic-add-new-competitor" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title" data-title="<?php esc_html_e('Add an item', 'seoaic');?>"></h3>
        </div>
        <div class="seoaic-popup__content">
            <form id="add-idea-form" class="seoaic-form" method="post">
                <input class="seoaic-form-item" type="hidden" name="action" value="seoaic_add_idea">
                <div class="seoaic-popup__field">
                    <label for="add-idea-name" class="text-label"><?php esc_html_e('Name', 'seoaic');?></label>
                    <input id="add-idea-name" class="seoaic-form-item" type="text" name="item_name" value="" required>
                </div>
                <div class="keywords-loc-and-lang-wrapper d-flex seoaic-gap-15">
                    <div class="seoaic-popup__field seoaic-w-100">
                        <label class="text-label mb-13"><?php esc_html_e('Location', 'seoaic');?></label>
                        <select name="seoaic_location" required class="seoaic-form-item form-select"></select>
                    </div>

                    <div class="seoaic-popup__field seoaic-w-100" style="display: none">
                        <label class="text-label mb-13"><?php esc_html_e('Language', 'seoaic');?></label>
                        <select name="seoaic_language" required class="seoaic-form-item form-select"></select>
                    </div>
                </div>

            </form>
        </div>
        <div class="seoaic-popup__footer">
            <button type="submit" form="add-idea-form"
                    class="seoaic-popup__btn"><?php esc_html_e('Create', 'seoaic');?></button>
        </div>
    </div>
</div>
