<?php

global $SEOAIC;

defined('ABSPATH') || exit;

?>
<div id="add-idea-translation" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title" data-title="<?php esc_html_e('Add an item', 'seoaic');?>"></h3>
        </div>
        <div class="seoaic-popup__content">
            <form id="add-idea-translation-form" class="seoaic-form" method="post">
                <input class="seoaic-form-item" type="hidden" name="action" value="seoaic_add_idea">
                <div class="seoaic-popup__field">
                    <label for="add-idea-translation-name" class="text-label"><?php esc_html_e('Name', 'seoaic');?></label>
                    <input id="add-idea-translation-name" class="seoaic-form-item" type="text" name="item_name" value="" required>
                </div>

                <?php
                $SEOAIC->multilang->get_translation_parent_input();
                $SEOAIC->multilang->get_languages_select();
                $SEOAIC->multilang->get_multilang_checkboxes('', 'radio');
                ?>

            </form>
        </div>
        <div class="seoaic-popup__footer">
            <button type="submit" form="add-idea-translation-form"
                    class="seoaic-popup__btn"><?php esc_html_e('Create', 'seoaic');?></button>
        </div>
    </div>
</div>
