<?php

global $SEOAIC;

defined('ABSPATH') || exit;

$keywords = $SEOAIC->keywords->getKeywords();

?>
<div id="add-idea-subtitle-keyword" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title" data-title="<?php esc_attr_e('Add an item', 'seoaic');?>"></h3>
        </div>
        <div class="seoaic-popup__content">
            <form id="add-idea-subtitle-keyword-form" class="seoaic-form" method="post">
                <input class="seoaic-form-item" type="hidden" name="action" value="seoaic_add_idea">
                <div class="seoaic-popup__field ">
                    <div class="add-idea-keyword-wrap">
                        <label for="seoaic_keywords-name" class="text-label add-idea-keyword text-label-keywords"><?php esc_html_e('Keywords', 'seoaic');?></label>
                        <select name="seoaic_keywords_name" id="seoaic_add_keywords_to_idea" class="seoaic_keywords_categories seoaic_add_keywords_to_idea seoaic-form-item form-select">
                            <?php if (empty($keywords)) : ?>
                                <option value=""><?php esc_html_e('None', 'seoaic') ?></option>
                            <?php else :
                                echo '<option value="">' . esc_html__('Choose keyword', 'seoaic') . '</option>';

                                foreach ($keywords as $keyword) {
                                    echo '<option value="' . esc_attr($keyword['name']).'" data-id="' . esc_attr($keyword['id']).'">' . esc_html($keyword['name']) . '</option>';
                                }
                                endif;
                            ?>
                        </select>
                    </div>

                    <div class="add-idea-subtitle-wrap">
                        <label for="add-idea-subtitle-keyword-name" class="text-label add-idea-subtitle text-label-keywords"><?php esc_html_e('Keywords', 'seoaic');?></label>
                        <input id="add-idea-subtitle-keyword-name" class="seoaic-form-item" type="text" name="item_name" value="">
                    </div>
                </div>

                <?php $SEOAIC->multilang->get_translation_parent_input(); ?>
                <?php $SEOAIC->multilang->get_languages_select(); ?>
            </form>
        </div>
        <div class="seoaic-popup__footer">
            <button type="submit"
                form="add-idea-subtitle-keyword-form"
                class="seoaic-popup__btn add-idea-subtitle-keyword-form edit-idea-keyword"
            ><?php esc_html_e('Create', 'seoaic');?></button>
        </div>
    </div>
</div>
