<?php

use SEOAIC\SEOAIC_SETTINGS;

global $SEOAIC;

defined('ABSPATH') || exit;

$keywords = $SEOAIC->keywords->getKeywords();
$pillarLinksOptionsString = '';

$isInternalLinksEnabled = SEOAIC_SETTINGS::isGenerateInternalLinksEnabled();
$isPillarLinksEnabled = SEOAIC_SETTINGS::isAddPillarLinksEnabled();
if ($isPillarLinksEnabled) {
    $pillarLinks = $SEOAIC->pillar_links->getPillarLinks();
    $pillarLinksOptionsString = $SEOAIC->pillar_links->makePillarLinksOptionsString($pillarLinks);
}
?>
<div id="add-idea-manually" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3 class="modal-title" data-title="<?php esc_html_e('Add an item', 'seoaic');?>"></h3>
        </div>
        <div class="seoaic-popup__content">
            <form id="add-idea-manually-form" class="seoaic-form" method="post">
                <input class="seoaic-form-item" type="hidden" name="action" value="seoaic_add_idea">
                <div class="seoaic-popup__field">
                    <label for="add-idea-manually-name" class="text-label"><?php esc_html_e('Name', 'seoaic');?></label>
                    <input id="add-idea-manually-name" class="seoaic-form-item" type="text" name="item_name" value="" required>
                </div>

                <div class="seoaic-popup__field">
                    <label class="text-label mb-10"><?php esc_html_e('Idea type', 'seoaic');?></label>
                    <select name="idea_template_type" class="seoaic-form-item form-select">
                        <?php
                        foreach (seoaic_get_prompt_template_types() as $key => $template_type) {
                            ?>
                            <option value="<?php echo esc_attr($key);?>"><?php echo esc_html($template_type);?></option>
                            <?php
                        }
                        ?>
                    </select>
                </div>

                <div class="seoaic-popup__field">
                    <div class="top label-keyword">
                        <label class="mb-10 mt-20 text-label"><?php echo esc_html_e('Choose keywords', 'seoaic');?></label>
                        <a href="<?php echo esc_url(admin_url('admin.php?page=seoaic-keywords'));?>"
                           target="_blank" class="link-keywords"><?php esc_html_e('Open the keywords table', 'seoaic');?>
                        </a>
                    </div>

                    <select name="select-keywords" multiple="multiple" class="seoaic-form-item">
                        <?php
                        foreach ($keywords as $keyword) {
                            echo '<option value="' . esc_attr($keyword['id']) . '">' . esc_html($keyword['name']) . '</option>';
                        }
                        ?>
                    </select>
                    <div class="d-flex mt-15">
                        <?php
                        if ($keywords) {
                            ?>
                            <div class="all-selector check mr-15">
                                <input type="checkbox" name="select_all_checkbox" id="select_all_checkbox" value="value">
                                <label for="select_all_checkbox"><?php esc_html_e('Select all', 'seoaic');?></label>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                </div>

                <?php
                if ($isInternalLinksEnabled) {
                    ?>
                    <div class="seoaic-popup__field">
                        <label class="mb-10 mt-20 text-label"><?php echo esc_html_e("Internal links", "seoaic");?></label>
                        <select
                            name="internal_links"
                            multiple="multiple"
                            class="seoaic-form-item form-select soaic-idea-internal-links"
                        ></select>
                        <div class="d-flex gap-15">
                            <a href="#"
                                class="internal-links-add-recommended small dn"
                                title="<?php esc_attr_e("Select up to 5 linked and related posts", "seoaic");?>"
                            ><?php esc_html_e("Add recommended", "seoaic");?></a>
                            <a href="#"
                                class="internal-links-load-random small d-flex"
                                title="<?php esc_attr_e("Load random posts and articles, and pre-select 5 of them. With multilang plugin enabled the results are based on the selected Language", "seoaic");?>"
                            ><?php esc_html_e("Random Posts", "seoaic");?></a>
                        </div>
                    </div>
                    <?php
                }

                if ($isPillarLinksEnabled) {
                    ?>
                    <div class="seoaic-popup__field">
                        <label class="mb-10 mt-20 text-label"><?php echo esc_html_e("Pillar links", "seoaic");?></label>
                        <select
                            name="pillar_links"
                            multiple="multiple"
                            class="seoaic-form-item form-select soaic-idea-pillar-links"
                        ><?php echo wp_kses(
                            $pillarLinksOptionsString,
                            [
                                'option' => [
                                    'value'         => [],
                                    'data-lang'     => [],
                                    'data-locale'   => [],
                                ],
                            ]
                        );?></select>
                        <div class="d-flex gap-15">
                            <a href="#"
                                class="pillar-links-select-random small d-flex"
                                title="<?php esc_attr_e("Select random pillar links. With multilang plugin enabled the results are based on the selected Language.", "seoaic");?>"
                            ><?php esc_html_e("Random", "seoaic");?></a>
                        </div>
                    </div>
                    <?php
                }

                if ($SEOAIC->multilang->is_multilang()) {
                    ?>
                    <div class="seoaic-popup__field">
                        <label class="text-label mb-10"><?php esc_html_e('Language', 'seoaic');?></label>
                        <?php $SEOAIC->multilang->get_translation_parent_input(); ?>
                        <?php $SEOAIC->multilang->get_multilang_checkboxes('', 'radio'); ?>
                    </div>
                    <?php
                }
                ?>
            </form>
        </div>
        <div class="seoaic-popup__footer">
            <button type="submit" form="add-idea-manually-form"
                    class="seoaic-popup__btn"><?php esc_html_e('Create', 'seoaic');?></button>
        </div>
    </div>
</div>
