<?php

defined('ABSPATH') || exit;

global $SEOAIC;
?>
<div id="add-competitors" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup add-competitors">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <div class="heading">
                <h3><?php esc_html_e('Competitors', 'seoaic'); ?></h3>
                <p><?php esc_html_e('keyword: ', 'seoaic'); ?><span></span></p>
            </div>
        </div>
        <div class="seoaic-popup__content">
            <div class="top">
                <?php echo $SEOAIC->competitors->my_article_popup_top_table_analysis(); ?>
            </div>
            <div class="table">
                <div class="averages">
                    <div class="averages-label-wrap">
                        <div class="competitor-kb">
                            <button id="add_competitor_to_kb" class="seoaic-black-button"><?php esc_html_e('Add to knowledge base', 'seoaic'); ?></button>
                        </div>
                        <div class="label-row"><?php esc_html_e('Averages', 'seoaic'); ?></div>
                    </div>
                    <div class="row-line article-analysis">
                        <div class="h1-titles">—</div>
                        <div class="h2-titles">—</div>
                        <div class="sentences">—</div>
                        <div class="keyword-density">—</div>
                        <div class="words">—</div>
                        <div class="paragraphs">—</div>
                        <div class="readability">—</div>
                    </div>
                </div>
                <div class="heading">
                    <div class="table-row">
                        <div class="visibility selected"><?php esc_html_e('Selected', 'seoaic'); ?> <span>(0)</span> <a
                                    class="unselect" href="#"><?php esc_html_e('Unselect All', 'seoaic'); ?></a></div>
                        <div class="domain"><?php esc_html_e('Domain', 'seoaic'); ?></div>
                        <div class="avg_position"><?php esc_html_e('Google Position', 'seoaic'); ?></div>
                    </div>
                </div>
                <div class="content-table">
                    <div class="body"></div>
                    <div class="competitor-article">
                        <a href="#" class="load-more-btn" data-action=""><?php esc_html_e('View more', 'seoaic'); ?></a>
                    </div>
                </div>
            </div>
        </div>
        <div class="seoaic-popup__pre-footer">
            <button type="button" data-action=""
                    class="seoaic-popup__btn open-modal open-content-explorer"><?php esc_html_e('Open Content Explorer', 'seoaic'); ?></button>
        </div>
        <div class="seoaic-popup__footer">
            <button type="button" data-action="seoaicAddedCompetitors"
                    class="seoaic-popup__btn seoaic-modal-close add_competitors"><?php esc_html_e('Save', 'seoaic'); ?></button>
        </div>
    </div>
</div>