<?php

defined('ABSPATH') || exit;

?>
<div id="seoaic-add-clusters-modal" class="seoaic-modal">
    <div class="seoaic-modal-background seoaic-modal-close"></div>
    <div class="seoaic-popup seoaic-ajax-form">
        <div class="seoaic-popup__header">
            <span class="seoaic-modal-close">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1 1L15 15M15 1L1 15" stroke="#F1EBF7" stroke-width="2"/>
                </svg>
            </span>
            <h3><?php esc_html_e('Add The Clusters', 'seoaic');?></h3>
        </div>
        <div class="seoaic-popup__content">
            <form id="seoaic-add-clusters-form" class="seoaic-form" method="post">
                <input type="hidden" name="action" value="seoaic_create_cluster" class="seoaic-ajax-field">
                <?php if (!empty($_GET['page']) && $_GET['page'] === 'seoaic-keywords') : ?>
                    <input type="hidden" name="no_toggle" value="1" class="seoaic-ajax-field">
                <?php endif;?>
                <div class="seoaic-popup__field">
                    <label class="text-label"><?php esc_html_e('Clusters (separated by new line)', 'seoaic');?></label>
                    <textarea name="names" class="seoaic-ajax-field" required></textarea>
                </div>
            </form>
        </div>
        <div class="seoaic-popup__footer">
            <button type="submit"
                    id="btn-add-keyword"
                    form="seoaic-add-clusters-form"
                    class="seoaic-popup__btn seoaic-ajax-submit seoaic-modal-close"
            ><?php esc_html_e('Add', 'seoaic');?></button>
        </div>
    </div>
</div>