<?php
if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

use SEOAIC\SeoaicContentImprovement;
use SEOAIC\SEOAIC_SETTINGS;

global $SEOAIC, $SEOAIC_OPTIONS;

$available_per_page_options = [10, 20, 50, 100, 200, 500, 1000];
$available_dates_options = [
    'last_7_days' => esc_html__('Last 7 days', 'seoaic'),
    'last_28_days' => esc_html__('Last 28 days', 'seoaic'),
    'last_3_months' => esc_html__('Last 3 months', 'seoaic'),
    'last_6_months' => esc_html__('Last 6 months', 'seoaic'),
    'last_12_months' => esc_html__('Last 12 months', 'seoaic'),
    'last_16_months' => esc_html__('Last 16 months', 'seoaic'),
];

$get = wp_unslash($_GET); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
$page = !empty($get['page']) ? $get['page'] : '';
$limit = !empty($get['limit']) ? $get['limit'] : 50;
$orderBy = !empty($get['orderBy']) ? $get['orderBy'] : 'clicks';
$order = !empty($get['order']) ? $get['order'] : 'DESC';

$currentMonth = !empty($get['publishedMonth']) ? sanitize_text_field($get['publishedMonth']) : '';

$monthOptions = seoaic_get_last_month_options(6);

?>
<div id="seoaic-admin-container" class="wrap">
    <h1 id="seoaic-admin-title">
        <?php
            echo wp_kses(seoai_get_logo('logo.svg'), [
                'img' => [
                    'title' => [],
                    'src'	=> [],
                    'alt'	=> [],
                ],
            ]);
        ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h1>
    <?php
        $loader_content = $SEOAIC->get_background_process_loader();
        if (!empty($loader_content)) {
            echo wp_kses($loader_content, [
                'div' => [
                    'id'    => [],
                    'class' => [],
                    'style' => [],
                    'title' => [],
                ],
                'p' => [
                    'class' => [],
                ],
                'b' => [],
                'button' => [
                    'type'              => [],
                    'class'             => [],
                    'data-modal'        => [],
                    'data-action'       => [],
                    'data-form-callback' => [],
                    'data-content'      => [],
                ],
            ]);
        }
    ?>
    <div id="seoaic-admin-body"
         class="columns-2
            seoaic-with-loader
            improvement-page
            content-improvement-ajax
            <?php echo esc_attr($page); ?>
            content-improvement
            <?php echo SEOAIC_SETTINGS::isGSCIntegrated() ? 'pruning-chart' : ''; ?>
            <?php echo !empty($SEOAIC_OPTIONS['seoaic_hide_individual_page_graph']) ? '' : 'show-page-graph'; ?>
        ">
        <div class="row full-width">
            <div class="col">
                <div class="inner">
                    <?php include_once(SEOAIC_DIR . 'inc/view/content-improvement/content-improvement-links.php'); ?>
                    <?php if (SEOAIC_SETTINGS::isGSCIntegrated()) : ?>
                        <div class="chart_pruning_wrap">
                            <div class="graph-header">
                                <div>
                                    <select id="seoaic_available_dates_options" class="form-select pp-select">
                                        <?php foreach ($available_dates_options as $key => $option_value) {
                                            ?>
                                            <option value="<?php echo esc_attr($key) ?>" <?php echo $key === 'last_3_months' ? 'selected' : '' ?>>
                                                <?php echo esc_html(strval($option_value)); ?>
                                            </option>
                                            <?php
                                        }
                                        ?>
                                        <option value="custom"><?php esc_html_e('Custom', 'seoaic'); ?></option>
                                    </select>
                                </div>
                                <div>
                                    <div class="position-relative">
                                        <input type="text" id="seoaic_graph_from" disabled name="seoaic_graph_from"
                                               value="" class="mt-0 seoaic-form-item form-input"
                                               placeholder="<?php esc_html_e('Select from', 'seoaic') ?>">
                                        <div class="picker-call"></div>
                                    </div>
                                </div>
                                <div>
                                    <div class="position-relative">
                                        <input type="text" id="seoaic_graph_to" disabled name="seoaic_graph_to" value=""
                                               class="mt-0 seoaic-form-item form-input"
                                               placeholder="<?php esc_html_e('Select to', 'seoaic') ?>">
                                        <div class="picker-call"></div>
                                    </div>
                                </div>
                                <div>
                                    <button type="submit" id="seoaic-graph-data" class="filter-search-btn"
                                            title="Filter"></button>
                                </div>
                                <div>
                                    <a href="<?php echo esc_url(get_admin_url()); ?>admin.php?page=seoaic-content-improvement"
                                       class="clear filter-clear-btn" title="Clear data for graph"></a>
                                </div>
                                <div>
                                    <button class="seoaic-graph-interval"
                                            data-interval="daily"><?php esc_html_e('Daily', 'seoaic') ?></button>
                                    <button class="seoaic-graph-interval active"
                                            data-interval="weekly"><?php esc_html_e('Weekly', 'seoaic') ?></button>
                                    <button class="seoaic-graph-interval"
                                            data-interval="monthly"><?php esc_html_e('Monthly', 'seoaic') ?></button>
                                </div>
                            </div>
                            <div id="chart_pruning_gsc" style="max-width: 100%"></div>
                        </div>
                    <?php endif; ?>
                    <?php include_once(SEOAIC_DIR . 'inc/view/content-improvement/filters.php'); ?>
                    <div class="bottom">
                        <div class="d-flex jc-e ">
                            <?php include_once(SEOAIC_DIR . 'inc/view/content-improvement/totals.php'); ?>
                            <div class="right-side d-flex ai-end">
                                <div class="d-flex ai-end">
                                    <div class="filter-published-date">
                                        <label for="seoaic_published_month" class="text-label">
                                            <?php esc_html_e('Show posts for...', 'seoaic'); ?>
                                        </label>
                                        <select id="seoaic_published_month" name="published_month" class="form-select-ci">
                                            <option value="all" <?php selected($currentMonth, 'all'); ?>>
                                                <?php esc_html_e('All time', 'seoaic'); ?>
                                            </option>

                                            <?php foreach ($monthOptions as $val => $label): ?>
                                                <option value="<?php echo esc_attr($val); ?>" <?php selected($currentMonth, $val); ?>>
                                                    <?php echo esc_html($label); ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="posts-per-page">
                                        <label class="text-label"><?php esc_html_e('Posts per page', 'seoaic'); ?></label>
                                        <select id="posts_per_page_ci" class="form-select-ci pp-select">
                                            <?php
                                                foreach ($available_per_page_options as $option_value) {
                                                $selected = strval($option_value) === strval($limit) ? 'selected' : '';
                                            ?>
                                                <option value="<?php echo esc_attr(strval($option_value)) ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html(strval($option_value)); ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                    <div class="d-flex ai-end action_button">
                                        <div class="ml-15 d-flex edit-buttons-wrap">
                                            <button class="button-primary seoaic-button-primary" disabled id="seoaic_analyse_audit"><?php esc_html_e('Audit selected', 'seoaic'); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="content-improvement-wrap">
                            <div class="flex-table scroll">
                                <div class="row-line heading">
                                    <div class="main-info">
                                        <div class="page-name" data-orderby="title">
                                            <input type="checkbox" name="selector" class="seoaic-checkbox select-all light right-15">
                                            <?php esc_html_e('Title', 'seoaic') ?>
                                        </div>
                                        <div class="page-url url"><?php esc_html_e('URL', 'seoaic') ?></div>
                                        <div
                                            class="index"
                                            data-orderby="<?php echo esc_attr(SeoaicContentImprovement::POSITION_FIELD); ?>"
                                            data-order="<?php echo esc_attr($orderBy === SeoaicContentImprovement::POSITION_FIELD ? $order : '');?>"
                                        >
                                            <?php esc_html_e('Score', 'seoaic') ?>
                                            <span></span>
                                        </div>
                                        <div
                                            class="impressions sort <?php echo $orderBy === SeoaicContentImprovement::IMPRESSION_FIELD ? 'active' : '' ?>"
                                            data-orderby="<?php echo esc_attr(SeoaicContentImprovement::IMPRESSION_FIELD); ?>"
                                            data-order="<?php echo esc_attr($orderBy === SeoaicContentImprovement::IMPRESSION_FIELD ? $order : '')?>"
                                        >
                                            <?php esc_html_e('Imp.', 'seoaic') ?>
                                            <span></span>
                                        </div>
                                        <div
                                            class="clicks sort <?php echo $orderBy === SeoaicContentImprovement::CLICKS_FIELD ? 'active' : '' ?>"
                                            data-orderby="<?php echo esc_attr(SeoaicContentImprovement::CLICKS_FIELD); ?>"
                                            data-order="<?php echo esc_attr($orderBy === SeoaicContentImprovement::CLICKS_FIELD ? $order : '') ?>"
                                        >
                                            <?php esc_html_e('Clicks', 'seoaic') ?>
                                            <span></span>
                                        </div>
                                        <div
                                            class="ctr sort <?php echo $orderBy === SeoaicContentImprovement::CTR_FIELD ? 'active' : '' ?>"
                                            data-orderby="<?php echo esc_attr(SeoaicContentImprovement::CTR_FIELD); ?>"
                                            data-order="<?php echo esc_attr($orderBy === SeoaicContentImprovement::CTR_FIELD ? $order : '')?>"
                                        >
                                            <?php esc_html_e('CTR', 'seoaic') ?>
                                            <span></span>
                                        </div>
                                        <div class="monitery sort <?php echo $orderBy === SeoaicContentImprovement::MONITERY_FIELD ? 'active' : '' ?>"
                                            data-orderby="<?php echo esc_attr(SeoaicContentImprovement::MONITERY_FIELD); ?>"
                                            data-order="<?php echo esc_attr($orderBy === SeoaicContentImprovement::MONITERY_FIELD ? $order : '')?>"
                                        >
                                            <?php esc_html_e('Value', 'seoaic') ?>
                                            <span></span>
                                        </div>
                                        <div class="edited"><?php esc_html_e('Last edited', 'seoaic') ?><span></span></div>
                                        <div class="published"><?php esc_html_e('Published', 'seoaic') ?><span></span></div>
                                        <div class="actions"><?php esc_html_e('Actions', 'seoaic') ?></div>
                                    </div>
                                </div>
                                <div id="hook_pages"></div>
                            </div>
                            <div class="seoaic-pagination pagination" id="pagination-container"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="lds-dual-ring"></div>
    </div>
</div>