<?php
if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

global $SEOAIC, $SEOAIC_OPTIONS;

$availablePerPageOptions = [10, 20, 50, 100, 200, 500, 1000];
$available_keywords_options = [
    'all' => esc_html__('All Keywords', 'seoaic'),
    'include' => esc_html__('Branded Keywords', 'seoaic'),
    'exclude' => esc_html__('Non-Branded Keywords', 'seoaic'),
];

$available_dates_options = [
    '3' => esc_html__('Last 3 months', 'seoaic'),
    '6' => esc_html__('Last 6 months', 'seoaic'),
    '12' => esc_html__('Last 12 months', 'seoaic'),
    '16' => esc_html__('Last 16 months', 'seoaic'),
];

$get = wp_unslash($_GET); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
$page = !empty($get['page']) ? $get['page'] : '';
$limit = !empty($get['limit']) ? $get['limit'] : 50;
$isBrandedKeywords = !empty($get['brandedKeywords']) ? $get['brandedKeywords'] : 'all';
$orderBy = !empty($get['orderBy']) ? $get['orderBy'] : 'clicks';
$order = !empty($get['order']) ? $get['order'] : 'DESC';
?>
<div id="seoaic-admin-container" class="wrap">
    <h1 id="seoaic-admin-title">
        <?php
            echo wp_kses(seoai_get_logo('logo.svg'), [
                'img' => [
                    'title' => [],
                    'src'	=> [],
                    'alt'	=> [],
                ],
            ]);
        ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h1>
    <?php
        $loader_content = $SEOAIC->get_background_process_loader();
        if (!empty($loader_content)) {
            echo wp_kses($loader_content, [
                'div' => [
                    'id'    => [],
                    'class' => [],
                    'style' => [],
                    'title' => [],
                ],
                'p' => [
                    'class' => [],
                ],
                'b' => [],
                'button' => [
                    'type'              => [],
                    'class'             => [],
                    'data-modal'        => [],
                    'data-action'       => [],
                    'data-form-callback' => [],
                    'data-content'      => [],
                ],
            ]);
        }
    ?>
    <div id="seoaic-admin-body"
         class="columns-2 seoaic-with-loader improvement-page content-improvement-ajax <?php echo esc_attr($page); ?> content-improvement">
        <div class="row full-width">
            <div class="col">
                <div class="inner">
                    <?php include_once(SEOAIC_DIR . 'inc/view/content-improvement/content-improvement-links.php'); ?>
                    <div class="chart_pruning_wrap">
                        <div class="graph-header">
                            <div>
                                <select id="seoaic_available_dates_options" class="form-select pp-select">
                                    <?php foreach ($available_dates_options as $key => $option_value) {
                                        ?>
                                        <option value="<?php echo esc_attr($key) ?>" <?php echo $key === 12 ? 'selected' : '' ?>>
                                            <?php echo esc_html(strval($option_value)); ?>
                                        </option>
                                        <?php
                                    }
                                    ?>
                                    <option value="custom"><?php esc_html_e('Custom', 'seoaic'); ?></option>
                                </select>
                            </div>
                            <div>
                                <div class="position-relative">
                                    <input type="text" id="seoaic_graph_from" disabled name="seoaic_graph_from"
                                            value="" class="mt-0 seoaic-form-item form-input"
                                            placeholder="<?php esc_html_e('Select from', 'seoaic') ?>">
                                    <div class="picker-call"></div>
                                </div>
                            </div>
                            <div>
                                <div class="position-relative">
                                    <input type="text" id="seoaic_graph_to" disabled name="seoaic_graph_to" value=""
                                            class="mt-0 seoaic-form-item form-input"
                                            placeholder="<?php esc_html_e('Select to', 'seoaic') ?>">
                                    <div class="picker-call"></div>
                                </div>
                            </div>
                            <div>
                                <button type="submit" id="seoaic-ranking-data" class="filter-search-btn" title="Filter"></button>
                            </div>
                            <div>
                                <a href="<?php echo esc_url(get_admin_url()); ?>admin.php?page=seoaic-rankings"
                                    class="clear filter-clear-btn" title="Clear data for graph"></a>
                            </div>
                        </div>
                        <div id="seoaic_rankings_chart"></div>
                    </div>
                    <?php include_once(SEOAIC_DIR . 'inc/view/content-improvement/filters.php'); ?>
                    <div class="bottom">
                        <div class="d-flex jc-e">
                            <?php include_once(SEOAIC_DIR . 'inc/view/content-improvement/totals.php'); ?>
                            <div class="right-side d-flex ai-end">
                                <div class="branded-keywords">
                                    <label for="seoaic_branded_keywords" class="text-label"><?php esc_html_e('Branded keywords', 'seoaic');?></label>
                                    <select id="seoaic_branded_keywords" class="form-select-ci pp-select">
                                        <?php
                                        foreach ($available_keywords_options as $key => $optionValue) {
                                            $selectedAttr = $isBrandedKeywords == $key ? ' selected' : '';
                                            ?>
                                                <option value="<?php echo esc_attr($key) ?>"<?php echo esc_attr($selectedAttr); ?>><?php echo esc_html($optionValue);?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            <div class="right-side d-flex ai-end">
                                <div class="posts-per-page">
                                    <label class="text-label"><?php esc_html_e('Per page', 'seoaic');?></label>
                                    <select id="posts_per_page_ci" class="form-select-ci pp-select">
                                        <?php
                                        foreach ($availablePerPageOptions as $optionValue) {
                                            $selectedAttr = $limit == $optionValue ? ' selected' : '';
                                            ?>
                                            <option value="<?php echo esc_attr(strval($optionValue)) ?>"<?php echo esc_attr($selectedAttr); ?>><?php echo esc_html(strval($optionValue));?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="content-improvement-wrap">
                            <div class="keywords-ranking-table flex-table scroll">

                                <div class="additional-info-row heading">
                                    <div class="actions ranking-actions">
                                        <button disabled="" data-ideas-label="<?php esc_html_e('Generate ideas after adding a keywords', 'seoaic');?>" data-modal="#add-keyword-modal" class="modal-button improve-add-keywords"><?php esc_html_e('Add to keywords', 'seoaic')?></button>
                                        <button disabled="" data-modal="#generate-ideas-new-keywords" class="modal-button improve-generate-ideas"><?php esc_html_e('Generate ideas', 'seoaic');?></button>
                                    </div>
                                    <div class="ranking-keyword" data-orderby="keyword">
                                        <span></span>
                                        <?php esc_html_e('Keywords', 'seoaic');?>
                                    </div>
                                    <div
                                        class="ranking-impressions sort <?php echo $orderBy === 'impressions' ? 'active' : '' ?>"
                                        data-orderby="impressions"
                                        data-order="<?php echo esc_attr($orderBy === 'impressions' ?$order : '')?>"
                                    >
                                        <?php esc_html_e('Impressions', 'seoaic');?>
                                        <span></span>
                                    </div>
                                    <div
                                        class="ranking-clicks sort <?php echo $orderBy === 'clicks' ? 'active' : '' ?>"
                                        data-orderby="clicks"
                                        data-order="<?php echo esc_attr($orderBy === 'clicks' ? $order : '')?>"
                                    >
                                        <?php esc_html_e('Clicks', 'seoaic');?>
                                        <span></span>
                                    </div>
                                    <div
                                        class="ranking-rank sort <?php echo $orderBy === 'position' ? 'active' : '' ?>"
                                        data-orderby="position"
                                        data-order="<?php echo esc_attr($orderBy === 'position' ? $order : '')?>"
                                    >
                                        <?php esc_html_e('Rank', 'seoaic');?>
                                        <span></span>
                                    </div>
                                    <div class="ranking-ctr sort <?php echo $orderBy === 'position' ? 'ctr' : '' ?>" data-orderby="ctr">
                                        <?php esc_html_e('CTR', 'seoaic');?>
                                        <span></span>
                                    </div>
                                    <div class="edited"><?php esc_html_e('Last edited', 'seoaic') ?><span></span></div>
                                    <div class="published"><?php esc_html_e('Published', 'seoaic') ?><span></span></div>
                                    <div class="ranking-page" data-orderby="post_title">
                                        <span><?php esc_html_e('Page', 'seoaic');?></span>
                                        <span class="sorting">
                                            <span class="asc">&darr;</span>
                                            <span class="desc">&darr;</span>
                                        </span>
                                    </div>
                                    <div class="ranking-serp">
                                        <span><?php esc_html_e('SERP', 'seoaic');?></span>
                                    </div>
                                </div>
                                <div id="hook_pages"></div>
                            </div>

                            <div class="seoaic-pagination pagination" id="pagination-container"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="lds-dual-ring"></div>
    </div>
</div>