<?php
if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

use SEOAIC\SeoaicContentImprovement;

global $SEOAIC, $SEOAIC_OPTIONS;

$availablePerPageOptions = [10, 20, 50, 100, 200, 500, 1000];

$available_dates_options = [
    'last_7_days' => esc_html__('Last 7 days', 'seoaic'),
    'last_28_days' => esc_html__('Last 28 days', 'seoaic'),
    'last_3_months' => esc_html__('Last 3 months', 'seoaic'),
    'last_6_months' => esc_html__('Last 6 months', 'seoaic'),
    'last_12_months' => esc_html__('Last 12 months', 'seoaic'),
    'last_16_months' => esc_html__('Last 16 months', 'seoaic'),
];

$get = wp_unslash($_GET); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
$page = !empty($get['page']) ? $get['page'] : '';
$limit = !empty($get['limit']) ? $get['limit'] : 50;
$orderBy = !empty($get['orderBy']) ? $get['orderBy'] : 'clicks';
$order = !empty($get['order']) ? $get['order'] : 'DESC';
?>
<div id="seoaic-admin-container" class="wrap">
    <h1 id="seoaic-admin-title">
        <?php
            echo wp_kses(seoai_get_logo('logo.svg'), [
                'img' => [
                    'title' => [],
                    'src'	=> [],
                    'alt'	=> [],
                ],
            ]);
        ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h1>
    <?php
        $loader_content = $SEOAIC->get_background_process_loader();
        if (!empty($loader_content)) {
            echo wp_kses($loader_content, [
                'div' => [
                    'id'    => [],
                    'class' => [],
                    'style' => [],
                    'title' => [],
                ],
                'p' => [
                    'class' => [],
                ],
                'b' => [],
                'button' => [
                    'type'              => [],
                    'class'             => [],
                    'data-modal'        => [],
                    'data-action'       => [],
                    'data-form-callback' => [],
                    'data-content'      => [],
                ],
            ]);
        }
    ?>
    <div id="seoaic-admin-body"
         class="columns-2 seoaic-with-loader improvement-page content-improvement-ajax <?php echo esc_attr($page); ?> content-improvement">
        <div class="row full-width">
            <div class="col">
                <div class="inner">
                    <?php include_once(SEOAIC_DIR . 'inc/view/content-improvement/content-improvement-links.php'); ?>
                    <?php include_once(SEOAIC_DIR . 'inc/view/content-improvement/filters.php'); ?>
                    <div class="bottom">
                        <div class="d-flex jc-e ai-center">
                            <div class="right-side d-flex ai-end">
                                <div class="posts-per-page">
                                    <label class="text-label"><?php esc_html_e('Posts per page', 'seoaic'); ?></label>
                                    <select id="posts_per_page_ci" class="form-select-ci pp-select">
                                        <?php
                                        foreach ($availablePerPageOptions as $optionValue) {
                                            $selectedAttr = $limit == $optionValue ? ' selected' : '';
                                            ?>
                                            <option value="<?php echo esc_attr(strval($optionValue)) ?>"<?php echo esc_attr($selectedAttr); ?>><?php echo esc_html(strval($optionValue));?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="content-improvement-wrap">
                            <div class="flex-table scroll">
                                <div class="row-line heading">
                                    <div class="main-info">
                                        <div class="page-name" data-orderby="title">
                                            <?php esc_html_e('Keyword', 'seoaic') ?>
                                        </div>
                                        <div class="page-url url"><?php esc_html_e('URL', 'seoaic') ?></div>
                                        <div class="top-kw"><?php esc_html_e('Top Page', 'seoaic') ?></div>
                                        <div class="overlapping sort" data-orderby="overlapping">
                                            <?php esc_html_e('Overlapping Page', 'seoaic') ?>
                                            <span></span>
                                        </div>
                                        <div class="impressions sort" data-orderby="<?php echo esc_attr(SeoaicContentImprovement::IMPRESSION_FIELD); ?>">
                                            <?php esc_html_e('Imp.', 'seoaic') ?>
                                            <span></span>
                                        </div>
                                        <div class="clicks active sort" data-orderby="<?php echo esc_attr(SeoaicContentImprovement::CLICKS_FIELD); ?>" data-order="DESC">
                                            <?php esc_html_e('Clicks', 'seoaic') ?>
                                            <span></span>
                                        </div>
                                        <div class="edited"><?php esc_html_e('Last edited', 'seoaic') ?><span></span></div>
                                        <div class="actions"><?php esc_html_e('Actions', 'seoaic') ?></div>
                                    </div>
                                </div>
                                <div id="hook_pages"></div>
                            </div>
                            <div class="seoaic-pagination pagination" id="pagination-container"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="lds-dual-ring"></div>
    </div>
</div>