<?php

use SEOAIC\SeoaicContentImprovement;

if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

global $SEOAIC, $SEOAIC_OPTIONS;

$available_per_page_options = [10, 20, 50, 100, 200, 500, 1000];
$available_keywords_options = [
    'all' => esc_html__('All Keywords', 'seoaic'),
    'include' => esc_html__('Branded Keywords', 'seoaic'),
    'exclude' => esc_html__('Non-Branded Keywords', 'seoaic'),
];
$available_status_options = [
    'new' => esc_html__('New', 'seoaic'),
    'gained' => esc_html__('Gained', 'seoaic'),
    'dropped' => esc_html__('Dropped', 'seoaic'),
    'dropped_out' => esc_html__('Dropped Out', 'seoaic'),
    'stable' => esc_html__('Stable', 'seoaic'),
];

$get = wp_unslash($_GET); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
$page = !empty($get['page']) ? $get['page'] : '';
$limit = !empty($get['limit']) ? $get['limit'] : 50;
$compare_from = !empty($get['compareKeywordPositionFrom']) ? $get['compareKeywordPositionFrom'] : 1;
$compare_to = !empty($get['compareKeywordPositionTo']) ? $get['compareKeywordPositionTo'] : 3;
$isBrandedKeywords = !empty($get['brandedKeywords']) ? $get['brandedKeywords'] : 'all';
$status = !empty($get['statusKeyword']) ? explode(',', $get['statusKeyword']) : [];
$orderBy = 'keyword';
$order = !empty($get['order']) ? $get['order'] : 'DESC';
?>
<div id="seoaic-admin-container" class="wrap">
    <h1 id="seoaic-admin-title">
        <?php
            echo wp_kses(seoai_get_logo('logo.svg'), [
                'img' => [
                    'title' => [],
                    'src'	=> [],
                    'alt'	=> [],
                ],
            ]);
        ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h1>
    <?php
        $loader_content = $SEOAIC->get_background_process_loader(true);
        if (!empty($loader_content)) {
            echo wp_kses($loader_content, [
                'div' => [
                    'id'    => [],
                    'class' => [],
                    'style' => [],
                    'title' => [],
                ],
                'p' => [
                    'class' => [],
                ],
                'b' => [],
                'button' => [
                    'type'              => [],
                    'class'             => [],
                    'data-modal'        => [],
                    'data-action'       => [],
                    'data-form-callback' => [],
                    'data-content'      => [],
                ],
            ]);
        }
    ?>
    <div id="seoaic-admin-body"
         class="columns-2 seoaic-with-loader improvement-page content-improvement-ajax <?php echo esc_attr($page); ?> content-improvement">
        <div class="row full-width">
            <div class="col">
                <div class="inner">
                    <?php include_once(SEOAIC_DIR . 'inc/view/content-improvement/content-improvement-links.php'); ?>
                    <?php include_once(SEOAIC_DIR . 'inc/view/content-improvement/filters.php'); ?>
                    <div class="bottom">
                        <div class="d-flex jc-sb ai-center">
                            <div class="seoai-position-tabs">
                                <div class="seo-tab-title"><h3><?php esc_html_e('Top positions:', 'seoaic')?></h3></div>
                                <div class="seo-tab active" data-compare-from="1" data-compare-to="3">1–3</div>
                                <div class="seo-tab" data-compare-from="4" data-compare-to="10">4–10</div>
                                <div class="seo-tab" data-compare-from="11" data-compare-to="30">11–30</div>
                            </div>
                            <div class="right-side d-flex ai-end">
                                <div class="branded-keywords">
                                    <label for="seoaic_status_keywords" class="text-label"><?php esc_html_e('Status', 'seoaic');?></label>
                                    <select id="seoaic_status_keywords" class="form-select-ci pp-select" multiple>
                                        <?php
                                        foreach ($available_status_options as $key => $optionValue) {
                                            $selectedAttr = in_array($key, $status) ? ' selected' : '';
                                            ?>
                                            <option value="<?php echo esc_attr($key); ?>"<?php echo $selectedAttr; ?>>
                                                <?php echo esc_html($optionValue); ?>
                                            </option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="branded-keywords">
                                    <label for="seoaic_branded_keywords" class="text-label"><?php esc_html_e('Branded keywords', 'seoaic');?></label>
                                    <select id="seoaic_branded_keywords" class="form-select-ci pp-select">
                                        <?php
                                        foreach ($available_keywords_options as $key => $optionValue) {
                                            $selectedAttr = $isBrandedKeywords == $key ? ' selected' : '';
                                            ?>
                                                <option value="<?php echo esc_attr($key) ?>"<?php echo esc_attr($selectedAttr); ?>><?php echo esc_html($optionValue);?></option>
                                            <?php
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="posts-per-page">
                                    <label class="text-label"><?php esc_html_e('Posts per page', 'seoaic'); ?></label>
                                    <select id="posts_per_page_ci" class="form-select-ci pp-select">
                                        <?php
                                            foreach ($available_per_page_options as $option_value) {
                                            $selected = strval($option_value) === strval($limit) ? 'selected' : '';
                                        ?>
                                            <option value="<?php echo esc_attr(strval($option_value)) ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html(strval($option_value)); ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="content-improvement-wrap">
                            <div class="flex-table scroll">
                                <div class="row-line heading">
                                    <div class="main-info">
                                        <div class="page-name sort active"
                                            data-orderby="keyword"
                                            data-order="<?php echo esc_attr($orderBy === 'keyword' ? $order : '')?>"
                                        ><?php esc_html_e('Keyword position:', 'seoaic') ?> <div class="keyword-position">1-3</div><span></span></div>
                                        <div class="position day-x"><?php esc_html_e('Position', 'seoaic') ?> <span>(<time><?php echo esc_html($dateFromValue); ?></time>)</span></div>
                                        <div class="position day-y"><?php esc_html_e('Position', 'seoaic') ?> <span>(<time><?php echo esc_html($dateToValue); ?></time>)</span></div>
                                        <div class="change status sort"
                                            data-orderby="change"
                                            data-order="<?php echo esc_attr($orderBy === SeoaicContentImprovement::CLICKS_GROWTH_FIELD ? $order : '')?>"
                                        ><?php esc_html_e('Change', 'seoaic') ?><span></span></div>
                                        <div class="status"><?php esc_html_e('Status', 'seoaic') ?></div>
                                        <div class="ctr day-x"><?php esc_html_e('CTR', 'seoaic') ?> <span>(<time><?php echo esc_html($dateFromValue); ?></time>)</span></div>
                                        <div class="ctr day-y"><?php esc_html_e('CTR', 'seoaic') ?> <span>(<time><?php echo esc_html($dateToValue); ?></time>)</span></div>
                                        <div class="clicks day-x"><?php esc_html_e('Clicks', 'seoaic') ?> <span>(<time><?php echo esc_html($dateFromValue); ?></time>)</span></div>
                                        <div class="clicks day-y"><?php esc_html_e('Clicks', 'seoaic') ?> <span>(<time><?php echo esc_html($dateToValue); ?></time>)</span></div>
                                        <div class="change status"><?php esc_html_e('Change', 'seoaic') ?></div>
                                        <div class="page"><?php esc_html_e('Page', 'seoaic') ?></div>
                                    </div>
                                </div>
                                <div id="hook_pages"></div>
                            </div>
                            <div class="seoaic-pagination pagination" id="pagination-container"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="lds-dual-ring"></div>
    </div>
</div>