<?php

use SEOAIC\SeoaicContentImprovement;

if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

global $SEOAIC, $SEOAIC_OPTIONS;

$available_per_page_options = [10, 20, 50, 100, 200, 500, 1000];

$get = wp_unslash($_GET); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
$page = !empty($get['page']) ? $get['page'] : '';
$limit = !empty($get['limit']) ? $get['limit'] : 50;
$orderBy = 'clicksGrowth';
$order = !empty($get['order']) ? $get['order'] : 'DESC';
?>
<div id="seoaic-admin-container" class="wrap">
    <h1 id="seoaic-admin-title">
        <?php
            echo wp_kses(seoai_get_logo('logo.svg'), [
                'img' => [
                    'title' => [],
                    'src'	=> [],
                    'alt'	=> [],
                ],
            ]);
        ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h1>
    <?php
        $loader_content = $SEOAIC->get_background_process_loader(true);
        if (!empty($loader_content)) {
            echo wp_kses($loader_content, [
                'div' => [
                    'id'    => [],
                    'class' => [],
                    'style' => [],
                    'title' => [],
                ],
                'p' => [
                    'class' => [],
                ],
                'b' => [],
                'button' => [
                    'type'              => [],
                    'class'             => [],
                    'data-modal'        => [],
                    'data-action'       => [],
                    'data-form-callback' => [],
                    'data-content'      => [],
                ],
            ]);
        }
    ?>
    <div id="seoaic-admin-body"
         class="columns-2 seoaic-with-loader improvement-page content-improvement-ajax <?php echo esc_attr($page); ?> content-improvement">
        <div class="row full-width">
            <div class="col">
                <div class="inner">
                    <?php include_once(SEOAIC_DIR . 'inc/view/content-improvement/content-improvement-links.php'); ?>
                    <?php include_once(SEOAIC_DIR . 'inc/view/content-improvement/filters.php'); ?>
                    <div class="bottom">
                        <div class="d-flex jc-sb ai-center full-width">
                            <?php include_once(SEOAIC_DIR . 'inc/view/content-improvement/trand-status.php'); ?>
                            <div class="right-side d-flex ai-end">
                                <div class="posts-per-page">
                                    <label class="text-label"><?php esc_html_e('Posts per page', 'seoaic'); ?></label>
                                    <select id="posts_per_page_ci" class="form-select-ci pp-select">
                                        <?php
                                            foreach ($available_per_page_options as $option_value) {
                                            $selected = strval($option_value) === strval($limit) ? 'selected' : '';
                                        ?>
                                            <option value="<?php echo esc_attr(strval($option_value)) ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html(strval($option_value)); ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="content-improvement-wrap">
                            <div class="flex-table scroll">
                                <div class="row-line heading">
                                    <div class="main-info">
                                        <div class="page-name" data-orderby="title"><?php esc_html_e('Page', 'seoaic') ?></div>
                                        <div class="impressions day-x"><?php esc_html_e('Impressions', 'seoaic') ?> (<time><?php echo esc_html($dateFromValue); ?></time>)</div>
                                        <div class="clicks day-x"><?php esc_html_e('Clicks', 'seoaic') ?> (<time><?php echo esc_html($dateFromValue); ?></time>)</div>
                                        <div class="impressions day-y"><?php esc_html_e('Impressions', 'seoaic') ?> (<time><?php echo esc_html($dateToValue); ?></time>)</div>
                                        <div class="clicks day-y"><?php esc_html_e('Clicks', 'seoaic') ?> (<time><?php echo esc_html($dateToValue); ?></time>)</div>
                                        <div class="clicks-diff sort"
                                            data-orderby="<?php echo esc_attr(SeoaicContentImprovement::CLICKS_DIFF_FIELD); ?>"
                                            data-order="<?php echo esc_attr($orderBy === SeoaicContentImprovement::CLICKS_DIFF_FIELD ? $order : '')?>"
                                        >
                                            <?php esc_html_e('Clicks Difference', 'seoaic') ?><span></span>
                                        </div>
                                        <div class="growth sort active"
                                            data-orderby="<?php echo esc_attr(SeoaicContentImprovement::CLICKS_GROWTH_FIELD); ?>"
                                            data-order="<?php echo esc_attr($orderBy === SeoaicContentImprovement::CLICKS_GROWTH_FIELD ? $order : '')?>"
                                        >
                                            <?php esc_html_e('Clicks Growth %', 'seoaic') ?><span></span>
                                        </div>
                                        <div class="publish-date"><?php esc_html_e('Published', 'seoaic') ?></div>
                                    </div>
                                </div>
                                <div id="hook_pages"></div>
                            </div>
                            <div class="seoaic-pagination pagination" id="pagination-container"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="lds-dual-ring"></div>
    </div>
</div>