<?php

use SEOAIC\SeoaicContentImprovement;
use SEOAIC\SEOAIC_SETTINGS;

if (!current_user_can('seoaic_edit_plugin')) {
    return;
}

global $SEOAIC, $SEOAIC_OPTIONS;

$available_per_page_options = [10, 20, 50, 100, 200, 500, 1000];
$available_dates_options = [
    'last_7_days' => esc_html__('Last 7 days', 'seoaic'),
    'last_28_days' => esc_html__('Last 28 days', 'seoaic'),
    'last_3_months' => esc_html__('Last 3 months', 'seoaic'),
    'last_6_months' => esc_html__('Last 6 months', 'seoaic'),
    'last_12_months' => esc_html__('Last 12 months', 'seoaic'),
    'last_16_months' => esc_html__('Last 16 months', 'seoaic'),
];
$available_redirect_options = [
    'all' => esc_html__('All Redirects', 'seoaic'),
    '301-redirect' => esc_html__('301 Redirect', 'seoaic'),
    '410-redirect' => esc_html__('410 Redirect', 'seoaic'),
];
$redirect_filter_options = [
    'all' => esc_html__('All Pages', 'seoaic'),
    'with_redirects' => esc_html__('Pages with Redirects', 'seoaic'),
    'without_redirects' => esc_html__('Pages without Redirects', 'seoaic'),
];
$post_types = seoaic_get_post_types();

$get = wp_unslash($_GET); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
$page = !empty($get['page']) ? $get['page'] : '';
$orderBy = 'impressions';
$order = !empty($get['order']) ? $get['order'] : 'DESC';
$redirectSuggestion = !empty($get['redirectSuggestion']) ? $get['redirectSuggestion'] : 'all';
$redirectFilter = !empty($get['redirectFilter']) ? $get['redirectFilter'] : 'all';
$limit = !empty($get['limit']) ? $get['limit'] : 50;
$selectedPostType = !empty($get['postType']) ? $get['postType'] : '';
$currentMonth = !empty($get['publishedMonth']) ? sanitize_text_field($get['publishedMonth']) : '';

$monthOptions = seoaic_get_last_month_options(18);

?>
<div id="seoaic-admin-container" class="wrap">
    <h1 id="seoaic-admin-title">
        <?php
            echo wp_kses(seoai_get_logo('logo.svg'), [
                'img' => [
                    'title' => [],
                    'src'	=> [],
                    'alt'	=> [],
                ],
            ]);
        ?>
        <span>
            <?php echo esc_html(get_admin_page_title()); ?>
        </span>
    </h1>
    <?php
        $loader_content = $SEOAIC->get_background_process_loader();
        if (!empty($loader_content)) {
            echo wp_kses($loader_content, [
                'div' => [
                    'id'    => [],
                    'class' => [],
                    'style' => [],
                    'title' => [],
                ],
                'p' => [
                    'class' => [],
                ],
                'b' => [],
                'button' => [
                    'type'              => [],
                    'class'             => [],
                    'data-modal'        => [],
                    'data-action'       => [],
                    'data-form-callback' => [],
                    'data-content'      => [],
                ],
            ]);
        }
    ?>
    <div id="seoaic-admin-body"
         class="columns-2 seoaic-with-loader improvement-page <?php echo esc_attr($page); ?> content-improvement content-improvement-ajax">
        <div class="row full-width">
            <div class="col">
                <div class="inner">
                    <?php include_once(SEOAIC_DIR . 'inc/view/content-improvement/content-improvement-links.php'); ?>
                    <?php include_once(SEOAIC_DIR . 'inc/view/content-improvement/filters.php'); ?>
                    <div class="bottom">
                        <div class="d-flex jc-e ai-center">
                            <div class="right-side d-flex ai-end seoaic-automated-pruning-actions">
                                <div class="filter-published-date">
                                    <label for="seoaic_published_month" class="text-label">
                                        <?php esc_html_e('Show posts for...', 'seoaic'); ?>
                                    </label>
                                    <select id="seoaic_published_month" name="published_month" class="form-select-ci">
                                        <option value="all" <?php selected($currentMonth, 'all'); ?>>
                                            <?php esc_html_e('All time', 'seoaic'); ?>
                                        </option>

                                        <?php foreach ($monthOptions as $val => $label): ?>
                                            <option value="<?php echo esc_attr($val); ?>" <?php selected($currentMonth, $val); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="redirect-filter-select">
                                    <label class="text-label"><?php esc_html_e('Post Types', 'seoaic'); ?></label>
                                    <select id="post_type_filter" class="form-select-ci pp-select">
                                        <option value="all"><?php esc_html_e('All Post Types', 'seoaic'); ?></option>
			                            <?php
			                            foreach ($post_types as $key => $post_type) {
				                            $selected = strval($post_type) === strval($selectedPostType) ? 'selected' : '';
				                            ?>
                                            <option value="<?php echo esc_attr(strval($post_type)) ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html(ucfirst($post_type)); ?></option>
			                            <?php } ?>
                                    </select>
                                </div>

                                <div class="redirect-filter-select">
                                    <label class="text-label"><?php esc_html_e('Redirect Filter', 'seoaic'); ?></label>
                                    <select id="redirect_filter" class="form-select-ci pp-select">
                                        <?php
                                            foreach ($redirect_filter_options as $key => $option_value) {
                                            $selected = strval($option_value) === strval($redirectFilter) ? 'selected' : '';
                                        ?>
                                            <option value="<?php echo esc_attr(strval($key)) ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html(strval($option_value)); ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="redirect-suggestion-select">
                                    <label class="text-label"><?php esc_html_e('Redirect suggestion', 'seoaic'); ?></label>
                                    <select id="redirect_suggestion" class="form-select-ci pp-select">
                                        <?php
                                            foreach ($available_redirect_options as $key => $option_value) {
                                            $selected = strval($option_value) === strval($redirectSuggestion) ? 'selected' : '';
                                        ?>
                                            <option value="<?php echo esc_attr(strval($key)) ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html(strval($option_value)); ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="posts-per-page">
                                    <label class="text-label"><?php esc_html_e('Posts per page', 'seoaic'); ?></label>
                                    <select id="posts_per_page_ci" class="form-select-ci pp-select">
                                        <?php
                                            foreach ($available_per_page_options as $option_value) {
                                            $selected = strval($option_value) === strval($limit) ? 'selected' : '';
                                        ?>
                                            <option value="<?php echo esc_attr(strval($option_value)) ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html(strval($option_value)); ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="d-flex ai-end action_button mass_action_button seoaic-suggestion-buttons">
                                    <div class="ml-15 d-flex edit-buttons-wrap">
                                        <button class="button-primary seoaic-button-primary" data-suggestion="revert" disabled id="seoaic_revert_suggestion"><?php esc_html_e('Revert suggestion', 'seoaic'); ?></button>
                                    </div>
                                    <div class="ml-15 d-flex edit-buttons-wrap">
                                        <button class="button-primary seoaic-button-primary" data-suggestion="apply" disabled id="seoaic_apply_suggestion"><?php esc_html_e('Apply suggestion', 'seoaic'); ?></button>
                                    </div>
                                    <div class="ml-15 d-flex edit-buttons-wrap">
                                        <button class="button-primary seoaic-button-primary seoaic-remove-suggestion disabled" data-suggestion="delete" disabled id="seoaic_delete_suggestion"><?php esc_html_e('Delete', 'seoaic'); ?></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="content-improvement-wrap">
                            <div class="flex-table scroll">
                                <div class="row-line heading">
                                    <div class="main-info">
                                        <div class="page-name" data-orderby="title">
                                            <input type="checkbox" name="selector" class="seoaic-checkbox select-all light right-15">
                                            <?php esc_html_e('Title', 'seoaic') ?>
                                        </div>
                                        <div class="impressions sort active"
                                            data-orderby="<?php echo esc_attr(SeoaicContentImprovement::IMPRESSION_FIELD); ?>"
                                            data-order="<?php echo esc_attr($orderBy === SeoaicContentImprovement::IMPRESSION_FIELD ? $order : '')?>"
                                        >
                                            <?php esc_html_e('Imp.', 'seoaic') ?>
                                            <span></span>
                                        </div>
                                        <div class="clicks">
                                            <?php esc_html_e('Clicks', 'seoaic') ?>
                                        </div>
                                        <div class="published"><?php esc_html_e('Published', 'seoaic') ?><span></span></div>
                                        <div class="edited"><?php esc_html_e('Edited', 'seoaic') ?><span></span></div>
                                        <div class="redirect">
                                            <span><?php esc_html_e('Redirect suggestion', 'seoaic'); ?>/</span>
                                            <span><?php esc_html_e('Pruning suggestion', 'seoaic'); ?></span>
                                        </div>
                                        <div class="actions"><?php esc_html_e('Actions', 'seoaic') ?></div>
                                    </div>
                                </div>
                                <div id="hook_pages"></div>
                            </div>
                            <div class="seoaic-pagination pagination" id="pagination-container"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="lds-dual-ring"></div>
    </div>
</div>