<?php
    use SEOAIC\SeoaicContentImprovement;

    $available_posts = [
        'all' => esc_html__('All Posts', 'seoaic'),
        'seoai' => esc_html__('SEO AI', 'seoaic'),
        'not-seoai' => esc_html__('Not SEO AI', 'seoaic'),
    ];

    $available_actions = [
        'seoaic-content-improvement' => 'seoaic_content_imptovement_get_pages',
        'seoaic-rankings' => 'seoaic_ranking_get_pages',
        'seoaic-automated-pruning' => 'seoaic_seoaic_automated_pruning_pages',
        'seoaic-keyword-cannibalisation' => 'seoaic_keyword_cannibalisation_pages',
        'seoaic-comparison' => 'seoaic_comparison_pages',
        'seoaic-keyword-analysation' => 'seoaic_keyword_analysation_pages'
    ];

    $get = wp_unslash($_GET); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    $page = !empty($get['page']) ? $get['page'] : '';
    $seoaicPost = !empty($get['seoaicPost']) ? $get['seoaicPost'] : 'all';

    if ($page === 'seoaic-automated-pruning') {
	    $dateFromValue = date('Y/m/d', strtotime('-180 days')); // phpcs:ignore WordPress.DateTime.RestrictedFunctions.date_date
	    $dateToValue = date('Y/m/d', strtotime('-90 days')); // phpcs:ignore WordPress.DateTime.RestrictedFunctions.date_date
	    $dateMode = 'days';
    } else {
	    $dateFromValue = !empty($get['dateFrom']) ? $get['dateFrom'] : date('Y/m', strtotime('-3 months')); // phpcs:ignore WordPress.DateTime.RestrictedFunctions.date_date
	    $dateToValue = !empty($get['dateTo']) ? $get['dateTo'] : date('Y/m', strtotime('-3 days')); // phpcs:ignore WordPress.DateTime.RestrictedFunctions.date_date
	    $dateMode = !empty($get['dateMode']) ? $get['dateMode'] : 'months';
    }

    $filterPosition = !empty($get['position']) ? urldecode($get['position']) : '';
    $filterImpressions = !empty($get['impressions']) ? urldecode($get['impressions']) : '';
    $filterClicks = !empty($get['clicks']) ? urldecode($get['clicks']) : '';
    $filterCTR = !empty($get['ctr']) ? urldecode($get['ctr']) : '';
    if (!empty($filterPosition)) {
        list($positionMin, $positionMax) = explode(',', $filterPosition);
    }
    if (!empty($filterImpressions)) {
        list($impressionsMin, $impressionsMax) = explode(',', $filterImpressions);
    }
    if (!empty($filterClicks)) {
        list($clicksMin, $clicksMax) = explode(',', $filterClicks);
    }
    if (!empty($filterCTR)) {
        list($ctrMin, $ctrMax) = explode(',', $filterCTR);
    }
?>
<form class="top" id="seoaic-pruning-form">
    <input type="hidden" class="seoaic_action" value="<?php echo esc_attr($available_actions[$page]) ?>">
    <div class="post-type form-item">
        <div class="dropdown-button">
            <div class="label"><?php esc_html_e($available_posts[$seoaicPost]) ?></div>
            <span class="dashicons dashicons-arrow-down-alt2"></span></div>
        <div class="dropdown-checkbox-list">
            <div class="checkbox-list-title"><?php esc_html_e('Show posts', 'seoaic') ?></div>
            <div class="checkbox-list radio-list">
                <?php foreach ($available_posts as $key => $name) : ?>
                    <?php $checkedRadio = 'all' === $key ? 'checked' : ''; ?>
                    <div class="checkbox-wrapper-mc">
                        <input id="seoaic_display_post-<?php echo esc_attr($key); ?>"
                                class="seoaic-form-item" name="seoaic_improve_display_post"
                                type="radio"
                                value="<?php echo esc_attr($key); ?>" <?php echo $key === $seoaicPost ? 'checked' : '' ?>>
                        <label for="seoaic_display_post-<?php echo esc_attr($key); ?>"
                                class="check">
                            <svg width="18px" height="18px" viewBox="0 0 18 18">
                                <path d="M1,9 L1,3.5 C1,2 2,1 3.5,1 L14.5,1 C16,1 17,2 17,3.5 L17,14.5 C17,16 16,17 14.5,17 L3.5,17 C2,17 1,16 1,14.5 L1,9 Z"></path>
                                <polyline points="1 9 7 14 15 4"></polyline>
                            </svg>
                            <span><?php echo esc_html($name); ?></span>
                        </label>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="checkbox-list-action">
                <button class="checkbox-list-button" data-select="all"><span
                            class="dashicons dashicons-saved"></span></button>
                <button class="checkbox-list-button" data-select="unselect"><span
                            class="dashicons dashicons-no-alt"></span></button>
            </div>
        </div>
    </div>
    <div class="search form-item">
        <input type="text" name="s" id="seoaic-search"
                value="<?php echo !empty($get['search']) ? esc_attr(urldecode($get['search'])) : ''; ?>"
                placeholder="<?php esc_html_e('Search...', 'seoaic'); ?>">
        <button id="seoaic-search-button" class="seoaic-button"></button>
        <p id="seoaic-search-message"></p>
    </div>
    <div class="range-wrapper form-item">
        <?php if ($page !== 'seoaic-keyword-analysation') : ?>
            <?php if ($page !== 'seoaic-automated-pruning' && $page !== 'seoaic-comparison') : ?>
                <div class="clicks <?php echo !empty($filterClicks) ? 'active' : ''; ?>" data-orderby="<?php echo esc_attr(SeoaicContentImprovement::CLICKS_FIELD); ?>">
                    <div class="active_range"></div>
                    <div class="item-wrap sort-range"
                            data-value="<?php echo esc_attr(SeoaicContentImprovement::CLICKS_FIELD); ?>"><?php esc_html_e('Clicks', 'seoaic') ?>
                        <span class="dashicons dashicons-arrow-down-alt2"></span></div>
                    <div class="range-popup">
                        <div class="f-words-count seoaic-settings-range seoaic-settings-range-2 mt-0 mb-0" data-min="0" data-max="0" data-step="1">
                            <label>
                                <span class="range-min"><?php echo !empty($clicksMin) ? esc_attr($clicksMin) : 0; ?></span>
                                -
                                <span class="range-max"><?php echo !empty($clicksMax) ? esc_attr($clicksMax) : 0; ?></span>
                                <input id="seoaic_clicks_range_min"
                                        class="seoaic-settings-range-min seoaic-form-item" type="hidden"
                                        name="clicks_range_min"
                                        value="<?php echo !empty($clicksMin) ? esc_attr($clicksMin) : 0; ?>">
                                <input id="seoaic_clicks_range_max"
                                        class="seoaic-settings-range-max seoaic-form-item" type="hidden"
                                        name="clicks_range_max"
                                        value="<?php echo !empty($clicksMax) ? esc_attr($clicksMax) : 0; ?>">
                            </label>
                            <div id="seoiac-modal-subtitles-range-slider"
                                    class="seoaic-settings-range-slider"></div>
                            <span class="seoaic-close">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                    <path d="M1 1L15 15M15 1L1 15" stroke="#100717"
                                            stroke-width="2"></path>
                                </svg>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="impression <?php echo !empty($filterImpressions) ? 'active' : ''; ?>" data-orderby="<?php echo esc_attr(SeoaicContentImprovement::IMPRESSION_FIELD); ?>">
                <div class="active_range"></div>
                <div class="item-wrap sort-range"
                        data-value="<?php echo esc_attr(SeoaicContentImprovement::IMPRESSION_FIELD); ?>"><?php esc_html_e('Imp.', 'seoaic') ?>
                    <span class="dashicons dashicons-arrow-down-alt2"></span></div>
                <div class="range-popup">
                    <div class="f-words-count seoaic-settings-range seoaic-settings-range-2 mt-0 mb-0" data-min="0" data-max="0" data-step="1">
                        <label>
                            <span class="range-min"><?php echo !empty($impressionsMin) ? esc_attr($impressionsMin) : 0; ?></span>
                            -
                            <span class="range-max"><?php echo !empty($clicksMax) ? esc_attr($clicksMax) : 0; ?></span>
                            <input id="seoaic_imp_range_min"
                                    class="seoaic-settings-range-min seoaic-form-item" type="hidden"
                                    name="imp_range_min"
                                    value="<?php echo !empty($impressionsMin) ? esc_attr($impressionsMin) : 0; ?>">
                            <input id="seoaic_imp_range_max"
                                    class="seoaic-settings-range-max seoaic-form-item" type="hidden"
                                    name="imp_range_max"
                                    value="<?php echo !empty($impressionsMax) ? esc_attr($impressionsMax) : 0; ?>">
                        </label>
                        <div id="seoiac-modal-subtitles-range-slider"
                                class="seoaic-settings-range-slider"></div>
                        <span class="seoaic-close">
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                <path d="M1 1L15 15M15 1L1 15" stroke="#100717"
                                        stroke-width="2"></path>
                            </svg>
                        </span>
                    </div>
                </div>
                </div>
            <?php endif; ?>
            <?php if ($page !== 'seoaic-keyword-cannibalisation' && $page !== 'seoaic-automated-pruning' && $page !== 'seoaic-comparison') : ?>
                <?php if ($page !== 'seoaic-content-improvement') : ?>
                    <div class="rank <?php echo !empty($filterPosition) ? 'active' : ''; ?>" data-orderby="<?php echo esc_attr(SeoaicContentImprovement::POSITION_FIELD); ?>">
                        <div class="active_range"></div>
                        <div class="item-wrap sort-range"
                                data-value="<?php echo esc_attr(SeoaicContentImprovement::POSITION_FIELD); ?>"><?php esc_html_e('Position', 'seoaic') ?>
                            <span class="dashicons dashicons-arrow-down-alt2"></span>
                        </div>

                        <div class="range-popup">
                            <div class="f-words-count seoaic-settings-range seoaic-settings-range-2 mt-0 mb-0" data-min="0" data-max="0" data-step="1">
                                <label>
                                    <span class="range-min"><?php echo !empty($positionMin) ? esc_attr($positionMin) : 0; ?></span>
                                    -
                                    <span class="range-max"><?php echo !empty($positionMax) ? esc_attr($positionMax) : 0; ?></span>
                                    <input id="seoaic_rank_range_min"
                                            class="seoaic-settings-range-min seoaic-form-item" type="hidden"
                                            name="ctr_range_min"
                                            value="<?php echo !empty($positionMin) ? esc_attr($positionMin) : 0; ?>">
                                    <input id="seoaic_rank_range_max"
                                            class="seoaic-settings-range-max seoaic-form-item" type="hidden"
                                            name="ctr_range_max"
                                            value="<?php echo !empty($positionMax) ? esc_attr($positionMax) : 0; ?>">
                                </label>
                                <div id="seoiac-modal-subtitles-range-slider"
                                        class="seoaic-settings-range-slider"></div>
                                <span class="seoaic-close">
                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1 1L15 15M15 1L1 15" stroke="#100717"
                                                stroke-width="2"></path>
                                    </svg>
                                </span>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="ctr <?php echo !empty($filterCTR) ? 'active' : ''; ?>" data-orderby="<?php echo esc_attr(SeoaicContentImprovement::CTR_FIELD); ?>">
                    <div class="active_range"></div>
                    <div class="item-wrap sort-range"
                            data-value="<?php echo esc_attr(SeoaicContentImprovement::CTR_FIELD); ?>"><?php esc_html_e('CTR.', 'seoaic') ?>
                        <span class="dashicons dashicons-arrow-down-alt2"></span></div>
                    <div class="range-popup">
                        <div class="f-words-count seoaic-settings-range seoaic-settings-range-2 mt-0 mb-0" data-min="0" data-max="0" data-step="1">
                            <label>
                                <span class="range-min"><?php echo !empty($ctrMin) ? esc_attr($ctrMin) : 0; ?></span>
                                -
                                <span class="range-max"><?php echo !empty($ctrMax) ? esc_attr($ctrMax) : 0; ?></span>
                                <input id="seoaic_ctr_range_min"
                                        class="seoaic-settings-range-min seoaic-form-item" type="hidden"
                                        name="ctr_range_min"
                                        value="<?php echo !empty($impressionsMin) ? esc_attr($impressionsMin) : 0; ?>">
                                <input id="seoaic_ctr_range_max"
                                        class="seoaic-settings-range-max seoaic-form-item" type="hidden"
                                        name="ctr_range_max"
                                        value="<?php echo !empty($ctrMax) ? esc_attr($ctrMax) : 0; ?>">
                            </label>
                            <div id="seoiac-modal-subtitles-range-slider"
                                    class="seoaic-settings-range-slider"></div>
                            <span class="seoaic-close">
                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                    <path d="M1 1L15 15M15 1L1 15" stroke="#100717"
                                            stroke-width="2"></path>
                                </svg>
                            </span>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
    <div class="data-range form-item">
        <?php if ( ! in_array( $page, ['seoaic-comparison', 'seoaic-automated-pruning'] ) ) : ?>
            <div class="actions">
                <button class="seoaic-select-date-range <?php echo $dateMode === 'days' ? 'active' : '' ?>" data-value="days">Daily</button>
                <button class="seoaic-select-date-range <?php echo $dateMode === 'months' ? 'active' : '' ?>" data-value="months">Monthly</button>
            </div>
        <?php endif; ?>
        <div class="sort-dated">
                <input type="text" id="seoaic-content-improvement-from"
                        value="<?php echo esc_attr($dateFromValue); ?>" placeholder="From"
                        data-default=""
                        <?= $page === 'seoaic-automated-pruning' ? 'data-view-mode="days" data-range-start="' . esc_attr($dateFromValue) . '"' : '' ?>>
                <span class="sep"></span>
                <input type="text" id="seoaic-content-improvement-to"
                        value="<?php echo esc_attr($dateToValue); ?>" placeholder="To" data-default=""
	                    <?= $page === 'seoaic-automated-pruning' ? 'data-range-end="'. esc_attr($dateToValue) . '"' : '' ?>>
            <div class="actions">
                <a href="<?php echo esc_url(get_admin_url()); ?>admin.php?page=<?php echo esc_attr($page); ?>"
                    class="filter-clear-btn"></a>
                <button id="seoaic-search-button" class="seoaic-button filter-search-btn"></button>
            </div>
        </div>
    </div>
</form>