<?php

$get = wp_unslash($_GET); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
$currentPage = !empty($get['page']) ? $get['page'] : '';
$pages = [
    'seoaic-content-improvement' => esc_html('Improve Content', 'seoaic'),
    'seoaic-rankings' => esc_html('Rankings', 'seoaic'),
    'seoaic-automated-pruning' => esc_html('Automated pruning', 'seoaic'),
    'seoaic-keyword-cannibalisation' => esc_html('Keyword cannibalization', 'seoaic'),
    'seoaic-comparison' => esc_html('Comparison', 'seoaic'),
    'seoaic-keyword-analysation' => esc_html('Keyword Analysis', 'seoaic')
];

$html = '<div class="header-actions">';

foreach ($pages as $key => $page) {
    $url = esc_url(admin_url("admin.php?page=$key"));
    $activeClass = $currentPage === $key ? 'active' : '';
    $html .= "<a href='$url' class='$activeClass'>$page</a>";
}

$html .= '</div>';

echo $html;