<?php
use SEOAIC\SEOAIC_SETTINGS;

add_action( 'admin_init', 'seoaic_settings_init' );

/**
 * Add settings
 */
function seoaic_settings_init() {

    register_setting( 'seoaic', 'seoaic_options' );

    add_settings_section(
        'seoaic_platform_api',
        esc_html__( 'SEO AI client settings', 'seoaic' ),
        'seoaic_platform_api_cb',
        'seoaic'
    );

    /*
    add_settings_field(
        'seoaic_platfrom_api_link',
        esc_html__( 'seoaic Token', 'seoaic' ),
        'seoaic_input_cb',
        'seoaic',
        'seoaic_platform_api',
        array(
            'label_for'         => 'seoaic_platfrom_api_link',
            'class'             => 'password',
            'type'              => 'text',
        )
    );
    */
}

function seoaic_platform_api_cb( $args ) {
}

function seoaic_input_cb( $args ) {
    global $SEOAIC_OPTIONS;

    ?>
    <input id="<?=esc_attr( $args['label_for'] );?>"
           class="<?=esc_attr( $args['class'] );?>"
           type="<?=esc_attr( $args['type'] );?>"
           name="seoaic_options[<?=esc_attr( $args['label_for'] );?>]"
           value="<?=( !empty($SEOAIC_OPTIONS) && !empty($SEOAIC_OPTIONS[ $args['label_for'] ]) ) ? esc_attr( $SEOAIC_OPTIONS[ $args['label_for'] ] ) : '';?>" />
    <?php
}

add_action( 'admin_menu', 'seoaic_options_page' );
add_action( 'admin_bar_menu', 'seoaic_add_to_top_bar', 100);

/**
 * Add menu and submenu in admin panel menu
 */
function seoaic_options_page() {
    global $SEOAIC_OPTIONS;
    global $plugin_page;

    $capability = 'seoaic_edit_plugin';

    add_menu_page(
        'Connection',
        'SEO AI',
        $capability,
        'seoaic',
        'seoaic_options_html'
    );

    add_submenu_page( 'seoaic', 'Connection', 'SEO AI Connection', $capability, 'seoaic', NULL );

    global $SEOAIC_OPTIONS;

    if (
        !empty($SEOAIC_OPTIONS['seoaic_api_email'])
        && !empty($SEOAIC_OPTIONS['seoaic_api_token'])
    ) {
        add_submenu_page( 'seoaic', 'Statistics', 'Dashboard', $capability, 'seoaic-company-dashboard', 'seoaic_dashboard_html' );
        add_submenu_page( 'seoaic', 'Site Audit', 'Site Audit', $capability, 'seoaic-seo-audit', 'seoaic_seo_audit_html' );
        add_submenu_page( 'seoaic', 'Keywords', 'Keywords', $capability, 'seoaic-keywords', 'seoaic_keywords_html' );
        add_submenu_page( 'seoaic', 'Ideas', 'Ideas', $capability, 'seoaic-ideas', 'seoaic_ideas_html' );
        add_submenu_page( 'seoaic', 'SEO AI created posts', 'Created posts', $capability, 'seoaic-created-posts', 'seoaic_created_posts_html' );
        add_submenu_page( 'seoaic', 'Competitors', 'Competitors', $capability, 'seoaic-competitors', 'seoaic_competitors_html' );
        add_submenu_page( 'seoaic', 'Knowledge Bases', 'Knowledge Bases', $capability, 'seoaic-knowledge-bases', 'seoaic_knowledge_bases_html' );
        add_submenu_page( 'seoaic', 'Calendar', 'Calendar', $capability, 'seoaic-calendar', 'seoaic_calendar_html' );
        add_submenu_page( 'seoaic', 'SEA', 'SEA', $capability, 'seoaic-sea-dashboard', 'seoaic_sea_dashboard_html' );
        add_submenu_page( 'seoaic', 'Brand Visibility', 'Brand Visibility', $capability, 'seoaic-brand-visibility', 'seoaic_brand_visibility_html' );
        add_submenu_page( 'seoaic', 'Brand Sentiment Analysis', 'Brand Sentiment Analysis', $capability, 'seoaic-brand-sentiment-analysis', 'seoaic_sentiment_analysis_html' );

        if (!SEOAIC_SETTINGS::isContentImprovementDisabled()) {
            add_submenu_page( 'seoaic', 'Content Improvement', 'Content Improvement', $capability, 'seoaic-content-improvement', 'seoaic_content_improvement_html' );
            add_submenu_page( 'seoaic', 'Pruning', 'Pruning', $capability, 'seoaic-pruning', 'seoaic_content_improvement_html' );
            add_submenu_page( 'seoaic', 'Rankings', 'Rankings', $capability, 'seoaic-rankings', 'seoaic_content_improvement_rankings_html' );
            add_submenu_page( 'seoaic', 'Automated pruning', 'Automated pruning', $capability, 'seoaic-automated-pruning', 'seoaic_content_improvement_automated_pruning_html' );
            add_submenu_page( 'seoaic', 'Keyword cannibalization', 'Keyword cannibalization', $capability, 'seoaic-keyword-cannibalisation', 'seoaic_content_improvement_keyword_cannibalisation_html' );
            add_submenu_page( 'seoaic', 'Comparison', 'Comparison', $capability, 'seoaic-comparison', 'seoaic_content_improvement__comparison_html' );
            add_submenu_page( 'seoaic', 'Keyword Analysis', 'Keyword Analysis', $capability, 'seoaic-keyword-analysation', 'seoaic_content_improvement_keyword_analysation_html' );
        }

        add_submenu_page( 'seoaic', 'Settings', 'Settings', $capability, 'seoaic-settings', 'seoaic_settings_html' );

        // Hide menu items using href styles
        add_submenu_page( 'seoaic', 'Automated Onboarding Wizard', 'Wizard', $capability, 'seoaic-onboarding-wizard', 'seoaic_onboarding_wizard_html' );
        add_submenu_page( 'seoaic', 'locations', 'Locations', $capability, 'seoaic-locations', 'seoaic_locations_html' );
        add_submenu_page( 'seoaic', 'Redirects', 'Redirects', $capability, 'seoaic-redirects', 'seoaic_redirects_html' );
        add_submenu_page( 'seoaic', 'Settings - Prompts', 'Settings - Prompts', $capability, 'seoaic-settings-prompts', 'seoaic_settings_prompts_html' );
        add_submenu_page( 'seoaic', 'Pillar links', 'Pillar links', $capability, 'seoaic-pillar-links', 'seoaic_pillar_links_html' );
        add_submenu_page( 'seoaic', 'Content Alerts', 'Content alerts', $capability, 'seoaic-settings-content-alerts', 'seoaic_settings_content_alerts_html');
        add_submenu_page( 'seoaic', 'Leads Interactive Form', 'Leads Interactive Form', $capability, 'seoaic-settings-leads-interactive-form', 'seoaic_settings_leads_interactive_form_html');
        add_submenu_page( 'seoaic', 'Streamlined onboarding', 'Streamlined onboarding', $capability, 'seoaic-streamlined-onboarding', 'seoaic_streamlined_onboarding_html' );
        add_submenu_page( 'seoaic', 'SEA select account', 'SEA select account', $capability, 'seoaic-sea-select-account', 'seoaic_sea_select_account_html' );
        add_submenu_page( 'seoaic', 'SEA Auth Successful', 'SEA Auth Successful', $capability, 'seoaic-sea-auth-success', 'seoaic_sea_auth_success_html' );
        add_submenu_page( 'seoaic', 'SEA Settings', 'SEA Settings', $capability, 'seoaic-sea-settings', 'seoaic_sea_settings_html' );
        add_submenu_page( 'seoaic', 'Custom Template Settings', 'Custom Template Settings', $capability, 'seoaic-custom-template-settings', 'seoaic_custom_template_html' );
    } else {
        // redirect to login page if user goes to other plugin's pages
        if ($plugin_page && (0 === strpos($plugin_page, 'seoaic-'))) {
            wp_redirect(admin_url('admin.php?page=seoaic'));
            exit;
        }
    }
}

function seoaic_get_submenus($exclude_slugs = []) {
    global $submenu;

    $parent_slug = 'seoaic';

    if (!isset($submenu[$parent_slug])) {
        return [];
    }

    $submenus = [];

    foreach ($submenu[$parent_slug] as $item) {
        if (in_array($item[2], $exclude_slugs)) {
            continue;
        }

        $submenus[] = [
            'title' => $item[0],
            'slug'  => $item[2],
            'capability' => $item[1],
        ];
    }

    return $submenus;
}

/**
 * Add menu and submenu in admin panel menu top bar
 */
function seoaic_add_to_top_bar($wp_admin_bar) {
    global $SEOAIC_OPTIONS;

    $capability = 'seoaic_edit_plugin';
    if (!current_user_can($capability)) {
        return;
    }

    $wp_admin_bar->add_node([
        'id'    => 'seoaic',
        'title' => '<img style="width: 18px;height: 18px;margin-right: 6px;vertical-align: sub;" src="' . esc_url(plugin_dir_url(dirname(__FILE__)) . 'assets/img/s-logo.png') . '" alt="seoaic-icon"> ' . esc_html('SEO AI'),
        'href'  => admin_url('admin.php?page=seoaic'),
    ]);

    if (
        !empty($SEOAIC_OPTIONS['seoaic_api_email'])
        && !empty($SEOAIC_OPTIONS['seoaic_api_token'])
    ) {
        $exclude_menus = [
            'seoaic',
            'seoaic-settings-content-alerts',
            'seoaic-pillar-links',
            'seoaic-settings-prompts',
            'seoaic-redirects',
            'seoaic-locations',
            'seoaic-onboarding-wizard',
            'seoaic-keyword-analysation',
            'seoaic-pruning',
            'seoaic-rankings',
            'seoaic-automated-pruning',
            'seoaic-keyword-cannibalisation',
            'seoaic-brand-sentiment-analysis',
            'seoaic-sea-select-account',
            'seoaic-sea-auth-success',
            'seoaic-sea-settings',
            'seoaic-settings-leads-interactive-form',
            'seoaic-comparison',
            'seoaic-streamlined-onboarding',
            'seoaic-custom-template-settings',
        ];

        foreach (seoaic_get_submenus($exclude_menus) as $submenu) {
            $wp_admin_bar->add_node([
                'id'     => 'seoaic-' . $submenu['slug'],
                'title'  => $submenu['title'],
                'href'   => admin_url('admin.php?page=' . $submenu['slug']),
                'parent' => 'seoaic',
            ]);
        }
    }
}

/**
 * Render seoai options page html
 */
function seoaic_options_html() {
    global $SEOAIC_OPTIONS;
    $seoaic_api_email = !empty($SEOAIC_OPTIONS['seoaic_api_email']) ? $SEOAIC_OPTIONS['seoaic_api_email'] : false;
    $seoaic_api_token = !empty($SEOAIC_OPTIONS['seoaic_api_token']) ? $SEOAIC_OPTIONS['seoaic_api_token'] : false;

    if (   empty($seoaic_api_token)
        || empty($seoaic_api_email)
    ) {

        $subpage = !empty($_GET['subpage']) ? $_GET['subpage'] : 'seoaic-login';
        switch ( $subpage ) {
            case 'seoaic-registration':
            case 'seoaic-login':
            case 'seoaic-forgot':
                include(SEOAIC_DIR . 'inc/view/' . $subpage . '-view.php');
                break;
        }

    } else {
        if ( empty($_GET['subpage']) ) {
            seoaicPageRender(SEOAIC_DIR . 'inc/view/seoaic-connected-view.php', 'position-relative connected bg-commect');
            include_once(SEOAIC_DIR . 'inc/view/popups/disconnect.php');
        } else {
            $subpage = $_GET['subpage'];
            // If the user has already set the data
            if (
                !empty($SEOAIC_OPTIONS['seoaic_business_name'])
                && !empty($SEOAIC_OPTIONS['seoaic_phone'])
                && !empty($SEOAIC_OPTIONS['seoaic_location'])
            ) {
                $subpage = 'default';
            }

            switch ($subpage) {
                case 'ideas':
                    include(SEOAIC_DIR . 'inc/view/seoaic-ideas-view.php');
                    break;
                case 'setinfo':
                    include(SEOAIC_DIR . 'inc/view/seoaic-setinfo-view.php');
                    break;
                default:
                    seoaicPageRender(SEOAIC_DIR . 'inc/view/seoaic-connected-view.php', 'position-relative connected bg-commect');
                    include_once(SEOAIC_DIR . 'inc/view/popups/disconnect.php');
            }
        }
    }
}

/**
 * Render ideas page html
 */
function seoaic_ideas_html() {
    include_once( SEOAIC_DIR . 'inc/view/seoaic-ideas-view.php' );
    include_once(SEOAIC_DIR . 'inc/view/popups/add-idea-manually.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/add-idea-subtitle-keyword.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/add-idea-translation.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/schedule-posts.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/edit-idea.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/plan-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/edit-idea-subtitle.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/alert-modal-2.php');
	include_once(SEOAIC_DIR . 'inc/view/popups/post-mass-outline-generate.php');
	include_once(SEOAIC_DIR . 'inc/view/popups/post-outline-generate.php');
}

/**
 * Render loactions page html
 */
function seoaic_locations_html() {
    include_once( SEOAIC_DIR . 'inc/view/seoaic-locations-view.php' );
    include_once(SEOAIC_DIR . 'inc/view/popups/add-locations-group.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/add-location.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/edit-group.php');
}

function seoaic_settings_prompts_html() {
    include_once( SEOAIC_DIR . 'inc/view/seoaic-settings-prompts-view.php');
}

function seoaic_pillar_links_html() {
    include_once( SEOAIC_DIR . 'inc/view/seoaic-pillar-links-view.php');
}

function seoaic_settings_content_alerts_html() {
    seoaicPageRender(SEOAIC_DIR . 'inc/view/seoaic-settings-content-alerts-view.php', 'bg-settings seoaic-content-alerts');
}

function seoaic_settings_leads_interactive_form_html() {
    seoaicPageRender(SEOAIC_DIR . 'inc/view/seoaic-settings-leads-interactive-form-view.php', 'bg-settings seoaic-settings-multistep-form');
}

function seoaic_onboarding_wizard_html() {
    $file = SEOAIC_DIR . 'inc/view/wizard/seoaic-wizard-view.php';

    if (file_exists($file)) {
        seoaicPageRender($file, 'wizard bg-wizard');

        include_once(SEOAIC_DIR . 'inc/view/popups/wizard-post-content.php');
        include_once(SEOAIC_DIR . 'inc/view/popups/wizard-generate-keywords.php');
        include_once(SEOAIC_DIR . 'inc/view/popups/wizard-generate-ideas.php');
        include_once(SEOAIC_DIR . 'inc/view/popups/wizard-generate-posts.php');
        include_once(SEOAIC_DIR . 'inc/view/popups/plan-modal.php');
    }
}

/**
 * Render dashboard page html
 */
function seoaic_dashboard_html() {
    global $SEOAIC_OPTIONS;

    $competitors_options = isset($SEOAIC_OPTIONS['competitors']) ? count($SEOAIC_OPTIONS['competitors']) : 0;

    seoaicPageRender(SEOAIC_DIR . 'inc/view/seoaic-dashboard-view.php', 'columns-2 dashboard-page', 'data-update-ready="" data-migrate-modal-content="Action is required: ' . esc_attr($competitors_options) . ' competitors needs to be migrated" data-migrate-competitors-options="' . esc_attr($competitors_options) . '"');
    include_once(SEOAIC_DIR . 'inc/view/popups/ranking-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-scan-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/dashboard-captured-leads.php');
	include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-dns-txt-integration-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-dns-cname-integration-modal.php');
}

/**
 * Render ideas page html
 */
function seoaic_seo_audit_html() {
    include_once(SEOAIC_DIR . 'inc/view/seoaic-seo-audit-view.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/performance-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/suggestion-modal.php');
}

/**
 * Render seoaic_streamlined_onboarding_html
 */
function seoaic_streamlined_onboarding_html() {
    include_once(SEOAIC_DIR . 'inc/view/seoaic-streamlined-onboarding.php' );
//    include_once(SEOAIC_DIR . 'inc/view/popups/performance-modal.php');
//    include_once(SEOAIC_DIR . 'inc/view/popups/wizard-post-content.php');
//    include_once(SEOAIC_DIR . 'inc/view/popups/wizard-generate-keywords.php');
//    include_once(SEOAIC_DIR . 'inc/view/popups/wizard-generate-ideas.php');
//    include_once(SEOAIC_DIR . 'inc/view/popups/wizard-generate-posts.php');
//    include_once(SEOAIC_DIR . 'inc/view/popups/plan-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/confirm-modal.php');
    //include_once(SEOAIC_DIR . 'inc/view/popups/reschedule-posts.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/accept-onboarding-ideas.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/review-ob-ideas.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/calendar-posts-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/settings-generate-description.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/add-clusters.php');
}

/**
 * Render seoaic_onboarding_clusters_html
 */
function seoaic_onboarding_clusters_html() {
//    include_once(SEOAIC_DIR . 'inc/view/seoaic-onboarding-clusters.php' );
//    include_once(SEOAIC_DIR . 'inc/view/popups/performance-modal.php');
//    include_once(SEOAIC_DIR . 'inc/view/popups/wizard-post-content.php');
//    include_once(SEOAIC_DIR . 'inc/view/popups/wizard-generate-keywords.php');
//    include_once(SEOAIC_DIR . 'inc/view/popups/wizard-generate-ideas.php');
//    include_once(SEOAIC_DIR . 'inc/view/popups/wizard-generate-posts.php');
//    include_once(SEOAIC_DIR . 'inc/view/popups/plan-modal.php');
//    include_once(SEOAIC_DIR . 'inc/view/popups/confirm-modal.php');
}

/**
 * Render competitors page html
 */
function seoaic_competitors_html() {
    include_once( SEOAIC_DIR . 'inc/view/seoaic-competitors-view.php' );
    include_once( SEOAIC_DIR . 'inc/view/popups/add-keyword.php');
    include_once( SEOAIC_DIR . 'inc/view/popups/add-new-competitor.php');
    include_once( SEOAIC_DIR . 'inc/view/popups/add-competitor-location.php');
    include_once( SEOAIC_DIR . 'inc/view/popups/competitors-compare.php');
    include_once( SEOAIC_DIR . 'inc/view/popups/add-competitors.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/rank-history.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/competitor-compare.php');
    //include_once(SEOAIC_DIR . 'inc/view/popups/search-terms-posts.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/search-terms-update-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/ranking-modal.php');
}

/**
 * Render created posts html
 */
function seoaic_created_posts_html() {
    seoaicPageRender(SEOAIC_DIR . 'inc/view/seoaic-created-posts-view.php', 'posts-page');
    include_once(SEOAIC_DIR . 'inc/view/popups/post-mass-edit.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/post-mass-review.php');
    require_once(SEOAIC_DIR . 'inc/view/popups/post-mass-translate.php');
    require_once(SEOAIC_DIR . 'inc/view/popups/reschedule-posts.php');
    require_once(SEOAIC_DIR . 'inc/view/popups/restore-posts-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/post-mass-add-thumbnail.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/post-mass-add-lead-form.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/post-mass-generate-lead-form.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/post-mass-generate-faq.php');
}

/**
 * Render created keywords html
 */
function seoaic_keywords_html() {
    include_once(SEOAIC_DIR . 'inc/view/seoaic-keywords-view.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/generate-keywords.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/add-keyword.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/rank-keyword.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/keyword-add-link.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/keywords-manage-categories.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/keywords-set-category.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/keyword-remove-and-reassign-confirm-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/keywords-show-created.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/add-competitors.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/keywords-show-ranked-keywords.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/keyword-add-location.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/keyword-rank-history.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/keywords-explorer.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-analyze.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/add-idea-manually.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/rank-keyword.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/competitor-compare.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/also-ask-generate-ideas.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/manage-clusters.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/add-clusters.php');
}

/**
 * Render created posts html
 */
function seoaic_settings_html() {
    seoaicPageRender(SEOAIC_DIR . 'inc/view/seoaic-settings-view.php', 'settings-page bg-settings');
    include_once(SEOAIC_DIR . 'inc/view/popups/settings-generate-description.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-scan-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-dns-txt-integration-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-dns-cname-integration-modal.php');
}

/**
 * Render created knowledge bases html
 */
function seoaic_knowledge_bases_html() {
    include_once( SEOAIC_DIR . 'inc/view/seoaic-knowledge-bases-view.php' );
}

/**
 * Render created calendar html
 */
function seoaic_calendar_html() {
    include_once( SEOAIC_DIR . 'inc/view/seoaic-calendar-view.php' );
    //include_once(SEOAIC_DIR . 'inc/view/popups/reschedule-posts.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/calendar-posts-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/accept-onboarding-ideas.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/review-ob-ideas.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/also-ask-generate-ideas.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/add-clusters.php');
}

/**
 * Render content improvement html
 */
function seoaic_content_improvement_html() {
    include_once( SEOAIC_DIR . 'inc/view/content-improvement/seoaic-content-improvement-view.php' );
    include_once( SEOAIC_DIR . 'inc/view/popups/content-improvement-analyze.php' );
    include_once( SEOAIC_DIR . 'inc/view/popups/seo-meta-improvement.php' );
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-scan-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/redirect_301.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/promote-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/sea/sea-create-campaign.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/sea/sea-create-ad-data.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-dns-txt-integration-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-dns-cname-integration-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/also-ask-generate-ideas.php');
}

/**
 * Render content improvement comparison html
 */
function seoaic_content_improvement__comparison_html() {
    include_once(SEOAIC_DIR . 'inc/view/content-improvement/seoaic-content-improvement-comparison-view.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-scan-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-dns-txt-integration-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-dns-cname-integration-modal.php');
}

/**
 * Render content improvement keyword analysation html
 */
function seoaic_content_improvement_keyword_analysation_html() {
    include_once(SEOAIC_DIR . 'inc/view/content-improvement/seoaic-content-improvement-keyword-analysation-view.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-scan-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-analyze.php');
}

/**
 * Render content improvement rankings html
 */
function seoaic_content_improvement_rankings_html() {
    include_once( SEOAIC_DIR . 'inc/view/content-improvement/seoaic-content-improvement-rankings-view.php' );
    include_once( SEOAIC_DIR . 'inc/view/popups/rankings-serp-modal.php' );
    include_once( SEOAIC_DIR . 'inc/view/popups/content-improvement-analyze.php' );
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-scan-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-dns-txt-integration-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-dns-cname-integration-modal.php');
}

/**
 * Render content improvement automated pruning html
 */
function seoaic_content_improvement_automated_pruning_html() {
    include_once(SEOAIC_DIR . 'inc/view/content-improvement/seoaic-content-improvement-automated-pruning-view.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/redirect_301.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-scan-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-dns-txt-integration-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-dns-cname-integration-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/suggestion-modal.php');
}

/**
 * Render content improvement keyword cannibalisation html
 */
function seoaic_content_improvement_keyword_cannibalisation_html() {
    include_once( SEOAIC_DIR . 'inc/view/content-improvement/seoaic-content-improvement-keyword-cannibalisation-view.php' );
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-scan-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-dns-txt-integration-modal.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/content-improvement-dns-cname-integration-modal.php');
}

/**
 * Redirects page html
 */
function seoaic_redirects_html() {
    seoaicPageRender(SEOAIC_DIR . 'inc/view/seoaic-redirects-view.php', 'content-improvement redirect-page');
    include_once( SEOAIC_DIR . 'inc/view/popups/add-redirects.php' );
    include_once( SEOAIC_DIR . 'inc/view/popups/suggestion-modal.php');
}

/**
 * Render SEA dashboard page html
 */
function seoaic_sea_dashboard_html() {
    seoaicPageRender(SEOAIC_DIR . 'inc/view/sea/seoaic-sea-dashboard.php', 'sea sea-dashboard-page');
    include_once(SEOAIC_DIR . 'inc/view/popups/sea/seoaic-sea-edit-campaign.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/sea/sea-performance.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/sea/sea-change-status.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/sea/sea-change-ad-group-status.php');
    include_once(SEOAIC_DIR . 'inc/view/popups/sea/sea-edit-ad-data.php');
}

/**
 * Render SEA select account page html
 */
function seoaic_sea_select_account_html() {
    seoaicPageRender(SEOAIC_DIR . 'inc/view/sea/seoaic-sea-select-account.php', 'sea sea-select-account-page');
}

/**
 * Render SEA auth success page html
 */
function seoaic_sea_auth_success_html() {
    seoaicPageRender(SEOAIC_DIR . 'inc/view/sea/seoaic-sea-auth-success.php', 'sea');
}

/**
 * Render SEA settings page html
 */
function seoaic_sea_settings_html() {
    seoaicPageRender(SEOAIC_DIR . 'inc/view/sea/seoaic-sea-settings.php', 'sea sea-settings-page');
}

function seoaic_custom_template_html() {
    seoaicPageRender(SEOAIC_DIR . 'inc/view/seoaic-settings-custom-template.php', 'seoaic-settings-custom-template');
}

/**
 * Brand Visibility page html
 */
function seoaic_brand_visibility_html() {
    include_once( SEOAIC_DIR . 'inc/view/seoaic-brand-visibility-view.php' );
    include_once( SEOAIC_DIR . 'inc/view/popups/generate-prompts.php');
    include_once( SEOAIC_DIR . 'inc/view/popups/generate-manual-prompts.php');
    include_once( SEOAIC_DIR . 'inc/view/popups/prompt-set-group.php');
    include_once( SEOAIC_DIR . 'inc/view/popups/create-competitor.php');
    include_once( SEOAIC_DIR . 'inc/view/popups/models-request-modal.php');
}

/**
 * Sentiment Analysis page html
 */
function seoaic_sentiment_analysis_html() {
    include_once( SEOAIC_DIR . 'inc/view/seoaic-brand-sentiment-analysis-view.php' );
}

function seoaic_options_page_html( $page = 'seoaic' ) {

    if ( ! current_user_can( 'edit_others_posts' ) ) {
        return;
    }

    if ( isset( $_GET['settings-updated'] ) ) {
        add_settings_error( 'seoaic_messages', 'seoaic_message', esc_html__( 'Settings Saved', 'mdsf' ), 'updated' );
    }

    settings_errors( 'seoaic_messages' );
    ?>
    <div class="wrap">
        <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
        <form action="options.php" method="post">
            <?php
            settings_fields( $page );
            do_settings_sections( $page );
            submit_button( 'Save Settings' );
            ?>
        </form>
    </div>
    <?php
}

function seoaic_add_plugin_capability() {
    global $SEOAIC_OPTIONS;
    $capability = 'seoaic_edit_plugin';
    wp_roles()->get_role('administrator')->add_cap($capability);

    if (isset($SEOAIC_OPTIONS['seoaic_access_role'])) {
        $all_roles = wp_roles()->roles;
        $allowed_roles = $SEOAIC_OPTIONS['seoaic_access_role'];

        foreach ($all_roles as $role_name => $role_info) {
            if ($role_name === 'administrator') {
                continue;
            }
            $role = get_role($role_name);
            if (in_array($role_name, $allowed_roles)) {
                $role->add_cap($capability);
            } else {
                $role->remove_cap($capability);
            }
        }
    }
}
add_action('init', 'seoaic_add_plugin_capability');
