<?php

namespace SEOAIC\traits;

trait Debug
{
    /**
     * Writes logs with details like class name and caller function. Uses print_r function.
     * @param any $data message or variable
     */
    public function debugLog(...$args)
    {
        $argsString = '';
        $maxLines = 3500;
        $fileName = SEOAIC_LOG . 'seoaic_debug.txt';

        $argsPrintedArray = array_map(function ($item) {
            return print_r($item, true);
        }, $args);
        $argsString = implode("\r\n--", $argsPrintedArray);

        $func_name = debug_backtrace()[1]['function'];
        $str = '[' . wp_date('Y-m-d H:i:s') . '] ' . __CLASS__ . ' -> ' . $func_name . "(): \r\n" . $argsString . "\r\n";
        //file_put_contents(SEOAIC_LOG . $fileName . '.txt', $str, FILE_APPEND);

        // remove old lines, and write a new one to the end
        if (!file_exists($fileName)) {
            $file = [];
        } else {
            $file = file($fileName);
            $file = array_slice($file, count($file) - $maxLines);
        }
        array_push($file, $str);
        file_put_contents($fileName, implode('', $file));
    }
}