<?php

namespace SEOAIC\shortcodes;

use SEOAIC\SEOAIC_SETTINGS;
use SEOAIC\shortcodes\interfaces\ShortcodeInterface;

class PostsArchiveLink implements ShortcodeInterface
{
    private $attrs;

    public function __construct($attrs = [], $content = '')
    {
        $this->attrs = empty($attrs) ? [] : (is_array($attrs) ? $attrs : [$attrs]);
    }

    private function makeHTML(): string
    {
        $class = !empty($this->attrs['class']) ? trim($this->attrs['class']) : '';
        $linkText = !empty($this->attrs['linkText']) ? trim($this->attrs['linkText']) : 'More SEO AI posts';
        $url = get_post_type_archive_link(SEOAIC_SETTINGS::SEOAI_POST);
        $link = $url ? '<a href="' . esc_url($url) . '" class="seoai-post-archive ' . esc_attr($class) . '">' . esc_html($linkText) . '</a>' : '';

        return $link;
    }

    public function html(): string
    {
        $html = $this->makeHTML();

        return $html;
    }
}
