<?php

namespace SEOAIC\shortcodes;

use SEOAIC\shortcodes\interfaces\ShortcodeInterface;

class PostUpdated implements ShortcodeInterface
{
    private $attrs;
    private $content;

    public function __construct($attrs = [], $content = '')
    {
        $this->attrs = empty($attrs) ? [] : (is_array($attrs) ? $attrs : [$attrs]);
        $this->content = $content;
    }

    private function makeHTML(): string
    {
        $format = !empty($this->attrs['format']) ? trim($this->attrs['format']) : get_option('date_format') . ' ' . get_option('time_format');
        $updatedText = !empty($this->attrs['updatedtext']) ? trim($this->attrs['updatedtext']) . ' ' : '';

        return esc_html($updatedText) . '<time datetime="' . get_the_modified_date("Y-m-d H:i:s") . '">' . get_the_modified_date($format) . '</time>';
    }

    public function html(): string
    {
        $html = $this->makeHTML();

        return $html;
    }
}
