<?php

namespace SEOAIC\shortcodes;

use SEOAIC\shortcodes\interfaces\ShortcodeInterface;

class PostTitle implements ShortcodeInterface
{
    private $attrs;
    private $content;

    public function __construct($attrs = [], $content = '')
    {
        $this->attrs = empty($attrs) ? [] : (is_array($attrs) ? $attrs : [$attrs]);
        $this->content = $content;
    }

    private function makeHTML(): string
    {
        $class = !empty($this->attrs['class']) ? '' . trim($this->attrs['class']) : '';

        return '<h1 class="entry-title seoaic-entry-title' . esc_attr($class) . '"><span>' . get_the_title() . '</span></h1>';
    }

    public function html(): string
    {
        $html = $this->makeHTML();

        return $html;
    }
}
