<?php

namespace SEOAIC\shortcodes;

use SEOAIC\shortcodes\interfaces\ShortcodeInterface;

class PostContent implements ShortcodeInterface
{
    private $attrs;
    private $content;

    public function __construct($attrs, $content = '')
    {
        $this->attrs = empty($attrs) ? [] : (is_array($attrs) ? $attrs : [$attrs]);
        $this->content = $content;
    }

    private function makeHTML(): string
    {
        $content = apply_filters('the_content', get_the_content());

        return $content;
    }

    public function html(): string
    {
        $html = $this->makeHTML();

        return $html;
    }
}
