<?php

namespace SEOAIC\shortcodes;

use SEOAIC\shortcodes\interfaces\ShortcodeInterface;

class PostAuthor implements ShortcodeInterface
{
    private $attrs;
    private $content;

    public function __construct($attrs = [], $content = '')
    {
        $this->attrs = empty($attrs) ? [] : (is_array($attrs) ? $attrs : [$attrs]);
        $this->content = $content;
    }

    private function makeHTML(): string
    {
        global $post;
        $postedByText = !empty($this->attrs['postedbytext']) ? trim($this->attrs['postedbytext']) . ' ' : '';

        $output = !empty($postedByText) ? '<span class="screen-reader-text">' . esc_html($postedByText) . '</span> ' : '';
        $output .= '<span class="author vcard"><a class="url fn n" href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '">' . get_the_author_meta('display_name' , $post->post_author) . '</a></span>';

        return $output;
    }

    public function html(): string
    {
        $html = $this->makeHTML();

        return $html;
    }
}
