<?php

namespace SEOAIC\shortcodes;

use SEOAIC\SeoaicLeadsAddon;
use SEOAIC\shortcodes\interfaces\ShortcodeInterface;

class MultistepForm implements ShortcodeInterface
{
    private $attrs;
    private $content;

    public function __construct($attrs, $content = '')
    {
        $this->attrs = $attrs;
        $this->content = $content;
        // add_action('wp_enqueue_scripts', [$this, 'inlineStylesFront']);
    }

    public static function makeInlineStyles()
    {
        $leadsFormSettings = SeoaicLeadsAddon::getSettings();

        $css = "
            .seoaic-multistep-form {
                background-color: {$leadsFormSettings['bg']} !important;
                border: {$leadsFormSettings['box_border_width']}px solid {$leadsFormSettings['box_border_color']} !important;
                border-radius: {$leadsFormSettings['border_radius']}px !important;
            }

            div.seoaic-multistep-form .seoaic-ms-step-question {
                background: {$leadsFormSettings['bot_msg_bg']};
                color: {$leadsFormSettings['bot_msg_color']};
                font-size: {$leadsFormSettings['bot_fontsize']}px;
                border-radius: {$leadsFormSettings['border_radius']}px;
                border: {$leadsFormSettings['bot_msg_border_width']}px solid {$leadsFormSettings['bot_msg_border_color']} !important;
            }

            .seoaic-multistep-form .seoaic-ms-text-message-wrapper {
                background: {$leadsFormSettings['bot_msg_bg']};
                color: {$leadsFormSettings['bot_msg_color']};
                font-size: {$leadsFormSettings['bot_fontsize']}px ;
                border-radius: {$leadsFormSettings['border_radius']}px;
                border: {$leadsFormSettings['bot_msg_border_width']}px solid {$leadsFormSettings['bot_msg_border_color']};
            }
            .seoaic-multistep-form .seoaic-ms-multi-items-wrapper label {
                background: {$leadsFormSettings['user_msg_bg']};
                color: {$leadsFormSettings['user_msg_color']};
                font-size: {$leadsFormSettings['user_fontsize']}px;
                border-radius: {$leadsFormSettings['border_radius']}px;
                border: {$leadsFormSettings['user_msg_border_width']}px solid {$leadsFormSettings['user_msg_border_color']};
            }

            .seoaic-multistep-form .seoaic-ms-textarea-content textarea {
                border-radius: {$leadsFormSettings['border_radius']}px;
                outline: 1px solid {$leadsFormSettings['user_msg_bg']};
            }

            .seoaic-multistep-form .seoaic-ms-contact-fields-wrapper {
                background: {$leadsFormSettings['user_msg_bg']};
                border-radius: {$leadsFormSettings['border_radius']}px;
                border: {$leadsFormSettings['user_msg_border_width']}px solid {$leadsFormSettings['user_msg_border_color']};
            }

            .seoaic-multistep-form .seoaic-ms-contact-field {
                border-radius: {$leadsFormSettings['border_radius']}px;
                outline: 1px solid {$leadsFormSettings['user_msg_bg']};
                font-size: {$leadsFormSettings['user_fontsize']}px;
            }

            .seoaic-multistep-form .seoaic-ms-contact-field-content label {
                color: {$leadsFormSettings['user_msg_color']};
                font-size: {$leadsFormSettings['user_fontsize']}px;
            }

            .seoaic-multistep-form .seoaic-ms-buttons-wrapper button {
                background: {$leadsFormSettings['user_msg_bg']} !important;
                color: {$leadsFormSettings['user_msg_color']} !important;
                font-size: {$leadsFormSettings['user_fontsize']}px !important;
                border-radius: {$leadsFormSettings['border_radius']}px !important;
                border: {$leadsFormSettings['user_msg_border_width']}px solid {$leadsFormSettings['user_msg_border_color']} !important;
            }

            .seoaic-multistep-form .seoaic-ms-answer-item {
                background: {$leadsFormSettings['user_msg_bg']};
                color: {$leadsFormSettings['user_msg_color']};
                font-size: {$leadsFormSettings['user_fontsize']}px;
                border-radius: {$leadsFormSettings['border_radius']}px;
                border: {$leadsFormSettings['user_msg_border_width']}px solid {$leadsFormSettings['user_msg_border_color']};
            }

            .seoaic-multistep-form .seoaic-ms-bot-icon.show {
                background-color: {$leadsFormSettings['bot_msg_bg']};
                background-size: 36px 36px;
                background-position: center center;
                background-repeat: no-repeat;
                border-radius: {$leadsFormSettings['border_radius']}px;
                border: {$leadsFormSettings['bot_icon_border_width']}px solid {$leadsFormSettings['bot_icon_border_color']};
                width: 36px;
                height: 36px;
                left: 0;
                padding: 6px;
                box-sizing: content-box;
            }

            .seoaic-multistep-form .seoaic-multistep-progress {
                height: {$leadsFormSettings['progress_height']}px;
                background-color: {$leadsFormSettings['progress_color']};
            }
        ";

        if (
            !empty($leadsFormSettings['bot_msg_icon'])
            && is_numeric($leadsFormSettings['bot_msg_icon'])
        ) {
            $url = wp_get_attachment_url($leadsFormSettings['bot_msg_icon']);

            $css .= "
            .seoaic-multistep-form .seoaic-ms-bot-icon {
                background-color: {$leadsFormSettings['bot_msg_bg']};
                background-image: url('" . $url . "');
                background-size: 36px 36px;
                background-position: center center;
                background-repeat: no-repeat;
                border-radius: {$leadsFormSettings['border_radius']}px;
                border: {$leadsFormSettings['bot_icon_border_width']}px solid {$leadsFormSettings['bot_icon_border_color']};
                width: 36px;
                height: 36px;
                left: 0;
                top: 0;
                padding: 5px;
                box-sizing: content-box;
            }

            .seoaic-multistep-form .seoaic-ms-step {
                padding-left: 60px;
            }
            ";
        }

        if (
            !empty($leadsFormSettings['box_add_shadow'])
            && 'on' == $leadsFormSettings['box_add_shadow']
        ) {
            $css .= "
            .seoaic-multistep-form {
                box-shadow: 0 0 7px 0px #717171 !important;
            }
            ";
        }

        return $css;
    }

    // public function inlineStylesFront()
    // {
    //     wp_add_inline_style('seoaic_front_main_css', self::makeInlineStyles());
    // }

    private function makeHTML(array $steps, array $attrs = []): string
    {
        $uniqueIdPrefix = uniqid('seoaic_ms_') . '_';

        ob_start();
        $cornerPosition = !empty($attrs['position']) && "corner" == $attrs['position'];
        $redirectURL = !empty($attrs['redirecturl']) ? esc_url($attrs['redirecturl']) : "";
        ?>
        <div
            class="seoaic-multistep-form <?php echo $cornerPosition ? esc_attr('seoaic-ms-position-corner') : '';?>"
            data-prefix="<?php echo esc_attr($uniqueIdPrefix);?>"
            data-redirecturl="<?php echo esc_attr($redirectURL);?>"
        >
            <?php
            foreach ($steps as $stepIndex => $step) {
                if (empty($step['id'])) {
                    continue;
                }

                $stepId = $uniqueIdPrefix . $step['id'];
                $autostep = !empty($step['autostep']) ? $uniqueIdPrefix . $step['autostep'] : '';
                $stepVisibilityClass = 0 < $stepIndex ? 'hide' : '';
                ?>
                <div
                    class="seoaic-ms-step <?php echo esc_attr($stepVisibilityClass);?>"
                    id="<?php echo esc_attr($stepId);?>"
                    data-type="<?php echo esc_attr($step['type']);?>"
                    data-autostep="<?php echo esc_attr($autostep);?>"
                >
                    <div class="seoaic-ms-bot-icon"></div>
                    <div class="seoaic-ms-step-question-wrapper">
                        <p class="seoaic-ms-step-question"><?php echo esc_html($step['question']);?></p>
                    </div>
                    <div class="seoaic-ms-step-content">
                        <?php
                        if ('single' == $step['type']) {
                            // buttons are below after all if-s, as there are no form items except the buttons

                        } else if ('multi' == $step['type']) {
                            ?>
                            <div class="seoaic-ms-multi-items-wrapper">
                                <?php
                                foreach ($step['formItems'] as $i => $formItem) {
                                    if (empty($formItem['text'])) {
                                        continue;
                                    }

                                    if ('checkbox' == $formItem['type']) {
                                        $optionId = $stepId . $i;
                                        ?>
                                        <label
                                            for="<?php echo esc_attr($optionId);?>"
                                            class="seoaic-ms-multi-item"
                                        >
                                            <input
                                                type="checkbox"
                                                id="<?php echo esc_attr($optionId);?>"
                                                value="<?php echo esc_attr($formItem['text']);?>"
                                            ><?php echo esc_html($formItem['text']);?>
                                        </label>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                            <?php


                        } else if ('textfield' == $step['type']) {
                            foreach ($step['formItems'] as $formItem) {
                                if ('textarea' == $formItem['type']) {
                                    $placeholderText = !empty($formItem) ? $formItem['placeholder'] : esc_html__("Write your answer", "seoaic");
                                    ?>
                                    <div class="seoaic-ms-textarea-wrapper">
                                        <div class="seoaic-ms-textarea-content">
                                            <textarea
                                                placeholder="<?php echo esc_attr($placeholderText);?>"
                                                required
                                            ></textarea>
                                        </div>
                                    </div>
                                    <?php
                                }
                            }

                        } else if ('text' == $step['type']) {
                            foreach ($step['formItems'] as $formItem) {
                                if (
                                    'message' == $formItem['type']
                                    && !empty($formItem['text'])
                                ) {
                                    ?>
                                    <div class="seoaic-ms-text-message-wrapper">
                                        <?php echo esc_html($formItem['text']);?>
                                    </div>
                                    <?php
                                }
                            }

                        } else if ('contact_fields' == $step['type']) {
                            if (empty($step['formItems'])) {
                                continue;
                            }
                            ?>
                            <div class="seoaic-ms-contact-fields-container">
                                <div class="seoaic-ms-contact-fields-wrapper">
                                    <?php
                                    foreach ($step['formItems'] as $i => $formItem) {
                                        if (empty($formItem['text'])) {
                                            continue;
                                        }

                                        $fieldId = $stepId . '_' . $i;
                                        $className = !empty($formItem['className']) ? $formItem['className'] . ' seoaic-field-has-icon' : '';
                                        ?>
                                        <div class="seoaic-ms-contact-field-content">
                                            <label for="<?php echo esc_attr($fieldId);?>"><?php echo esc_html($formItem['text']);?></label>
                                            <?php
                                            if ('select' == $formItem['type']) {
                                                ?>
                                                <select
                                                    id="<?php echo esc_attr($fieldId);?>"
                                                    data-label="<?php echo esc_attr($formItem['text']);?>"
                                                    class="seoaic-ms-contact-field"
                                                >
                                                    <?php
                                                    if (!empty($formItem['options'])) {
                                                        foreach ($formItem['options'] as $optionText) {
                                                            if (empty($optionText)) {
                                                                continue;
                                                            }
                                                            ?>
                                                            <option value="<?php echo esc_attr($optionText);?>"><?php echo esc_html($optionText);?></option>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                                <?php

                                            } else if (in_array($formItem['type'], ['text', 'tel','email'])) {
                                                $type = !empty($formItem['type']) ? $formItem['type'] : 'text';
                                                ?>
                                                    <div class="<?php echo esc_attr($className);?>">
                                                        <input
                                                            type="<?php echo esc_attr($type);?>"
                                                            id="<?php echo esc_attr($fieldId);?>"
                                                            data-label="<?php echo esc_attr($formItem['text']);?>"
                                                            class="seoaic-ms-contact-field"
                                                            required
                                                        >
                                                    </div>
                                                <?php
                                            }
                                            ?>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                            <?php
                        }

                        if (
                            !empty($step['buttons'])
                            && is_array($step['buttons'])
                        ) {
                            ?>
                            <div class="seoaic-ms-buttons-wrapper">
                                <?php
                                foreach ($step['buttons'] as $button) {
                                    if (
                                        empty($button['text'])
                                        || empty($button['step'])
                                    ) {
                                        continue;
                                    }

                                    $buttonStepId = $uniqueIdPrefix . $button['step'];
                                    ?>
                                    <button
                                        data-step-id="<?php echo esc_attr($buttonStepId);?>"
                                    ><?php echo esc_html($button['text']);?></button>
                                    <?php
                                }
                                ?>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                    <?php
                    if ('text' != $step['type']) {
                        ?>
                        <div class="seoaic-ms-step-answers-wrapper"></div>
                        <?php
                    }
                    ?>
                </div>
                <?php
            }
            ?>
            <div class="seoaic-multistep-progress"></div>
        </div>
        <?php
        $html = ob_get_clean();

        return $html;
    }

    public function html(): string
    {
        $content = html_entity_decode($this->content);
        $content = stripslashes($content);
        // $content = iconv('UTF-8', 'ASCII//TRANSLIT', $content);
        $steps = json_decode($content, true);
        $jsonError = json_last_error();

        if ($jsonError !== JSON_ERROR_NONE) {
            return esc_html__('Multistep Form broken data:', 'seoaic') . ' JSON error ' . $jsonError;
        }

        $html = $this->makeHTML($steps, $this->attrs);

        return $html;
    }
}
