<?php

namespace SEOAIC\shortcodes;

use SEOAIC\Company;
use SEOAIC\SeoaicLeadsAddon;
use SEOAIC\shortcodes\interfaces\ShortcodeInterface;

class InteractiveArticleBlock implements ShortcodeInterface
{
    private $attrs;
    private $content;

    public function __construct($attrs, $content = '')
    {
        $this->attrs = !empty($attrs) ? $attrs : [];
        $this->content = $content;

        // add_action('wp_enqueue_scripts', [$this, 'inlineStylesFront']);
    }

    public static function makeInlineStyles()
    {
        $leadsFormSettings = SeoaicLeadsAddon::getSettings();
//         .seoaic-multistep-form {
    //             background-color:{$leadsFormSettings['bg']};
    //         }
    //         .seoaic-ia-block-question {
    //             background: {$leadsFormSettings['bot_msg_bg']};
    //             color: {$leadsFormSettings['bot_msg_color']};
    //             font-size: {$leadsFormSettings['bot_fontsize']}px;
    //             border-radius: {$leadsFormSettings['border_radius']}px;
    //             border: {$leadsFormSettings['bot_msg_border_width']}px solid {$leadsFormSettings['bot_msg_border_color']};
    //         }
    //         .seoaic-ia-text-message-wrapper {
    //             background: {$leadsFormSettings['bot_msg_bg']};
    //             color: {$leadsFormSettings['bot_msg_color']};
    //             font-size: {$leadsFormSettings['bot_fontsize']}px;
    //             border-radius: {$leadsFormSettings['border_radius']}px;
    //             border: {$leadsFormSettings['bot_msg_border_width']}px solid {$leadsFormSettings['bot_msg_border_color']};
    //         }

    //         .seoaic-ia-textarea-content textarea {
    //             border-radius: {$leadsFormSettings['border_radius']}px;
    //             outline: 1px solid {$leadsFormSettings['user_msg_bg']};
    //         }
    //         .seoaic-ia-contact-fields-wrapper {
    //             background: {$leadsFormSettings['user_msg_bg']};
    //             border-radius: {$leadsFormSettings['border_radius']}px;
    //             border: {$leadsFormSettings['user_msg_border_width']}px solid {$leadsFormSettings['user_msg_border_color']};
    //         }
    //         .seoaic-multistep-form .seoaic-ia-contact-field {
    //             border-radius: {$leadsFormSettings['border_radius']}px;
    //             outline: 1px solid {$leadsFormSettings['user_msg_bg']};
    //             font-size: {$leadsFormSettings['user_fontsize']}px;
    //         }

    //         .seoaic-ia-answer-item {
    //             background: {$leadsFormSettings['user_msg_bg']};
    //             color: {$leadsFormSettings['user_msg_color']};
    //             font-size: {$leadsFormSettings['user_fontsize']}px;
    //             border-radius: {$leadsFormSettings['border_radius']}px;
    //             border: {$leadsFormSettings['user_msg_border_width']}px solid {$leadsFormSettings['user_msg_border_color']};
    //         }

    //         .seoaic-ia-bot-icon.show {
    //             background-color: {$leadsFormSettings['bot_msg_bg']};
    //             background-size: 36px 36px;
    //             background-position: center center;
    //             background-repeat: no-repeat;
    //             border-radius: {$leadsFormSettings['border_radius']}px;
    //             border: {$leadsFormSettings['bot_icon_border_width']}px solid {$leadsFormSettings['bot_icon_border_color']};
    //             width: 36px;
    //             height: 36px;
    //             left: 0;
    //             top: 20px;
    //             padding: 6px;
    //             box-sizing: content-box;
    //         }
        $css = "

            .seoaic-ia-buttons-content button {
                background: {$leadsFormSettings['user_msg_bg']};
                color: {$leadsFormSettings['user_msg_color']};
                font-size: {$leadsFormSettings['user_fontsize']}px;
                border-radius: {$leadsFormSettings['border_radius']}px;
                border: {$leadsFormSettings['user_msg_border_width']}px solid {$leadsFormSettings['user_msg_border_color']};
            }

            .seoaic-ia-multi-items-wrapper label {
                background: {$leadsFormSettings['user_msg_bg']};
                color: {$leadsFormSettings['user_msg_color']};
                font-size: {$leadsFormSettings['user_fontsize']}px;
                border-radius: {$leadsFormSettings['border_radius']}px;
                border: {$leadsFormSettings['user_msg_border_width']}px solid {$leadsFormSettings['user_msg_border_color']};
            }

            .seoaic-ia-textarea-content textarea {
                border-radius: {$leadsFormSettings['border_radius']}px;
                outline: 1px solid {$leadsFormSettings['user_msg_bg']};
            }

        ";

        return $css;
    }

    // public function inlineStylesFront()
    // {
    //     wp_add_inline_style('seoaic_front_main_css', self::makeInlineStyles());
    // }

    private function makeHTML(array $params, array $attrs = []): string
    {
        // error_log('params '.print_r($params, true));
        $uniqueIdPrefix = 'seoaic_ia_block_';
        $blockId = $uniqueIdPrefix . $params['id'];
        $postId = isset($params['post_id']) ? $params['post_id'] : '';
        $type = isset($params['type']) ? $params['type'] : '';

        ob_start();
        ?>
        <div
            class="seoaic-interactive-article-block seoaic-ia-hide-if-no-js"
            id="<?php echo esc_attr($blockId);?>"
            data-id="<?php echo esc_attr($params['id']);?>"
            data-post-id="<?php echo esc_attr($postId);?>"
            data-prefix="<?php echo esc_attr($uniqueIdPrefix);?>"
            data-type="<?php echo esc_attr($type);?>"
        >
            <div class="seoaic-ia-block-question-wrapper">
                <h4 class="seoaic-ia-block-question"><?php echo esc_html($params['question']);?></h4>
            </div>
            <div class="seoaic-ia-block-content">
                <?php
                if ('single' == $type) {
                    // buttons are below after all if-s, as there are no form items except the buttons
                } else if ('multi' == $type) {
                    ?>
                    <div class="seoaic-ia-multi-items-wrapper">
                        <?php
                        foreach ($params['answers'] as $i => $answer) {
                            if (empty($answer['text'])) {
                                continue;
                            }

                            $optionId = $blockId . $i;
                            ?>
                            <label
                                for="<?php echo esc_attr($optionId);?>"
                                class="seoaic-ia-multi-item"
                            >
                                <input
                                    type="checkbox"
                                    id="<?php echo esc_attr($optionId);?>"
                                    value="<?php echo esc_attr($answer['text']);?>"
                                    <?php echo !empty($answer['id']) ? 'data-id="' . esc_attr($answer['id']) . '"' : '';?>
                                ><?php echo esc_html($answer['text']);?>
                            </label>
                            <?php
                        }
                        ?>
                    </div>
                    <?php

                } else if ('textfield' == $type) {
                    foreach ($params['answers'] as $i => $answer) {
                        $placeholderText = !empty($answer['placeholder']) ? $answer['placeholder'] : esc_html__("Write your answer", "seoaic");
                        ?>
                        <div class="seoaic-ia-textarea-wrapper">
                            <div class="seoaic-ia-textarea-content">
                                <textarea
                                    placeholder="<?php echo esc_attr($placeholderText);?>"
                                ></textarea>
                            </div>
                        </div>
                       <?php
                    }
                }

                if (
                    !empty($params['buttons'])
                    && is_array($params['buttons'])
                ) {
                    ?>
                    <div class="seoaic-ia-buttons-wrapper">
                        <div class="seoaic-ia-buttons-content">
                            <?php
                            foreach ($params['buttons'] as $button) {
                                if (
                                    empty($button['text'])
                                    || empty($button['step'])
                                ) {
                                    continue;
                                }

                                $buttonStepId = $uniqueIdPrefix . $button['step'];
                                ?>
                                <button
                                    data-step-id="<?php echo esc_attr($buttonStepId);?>"
                                    <?php echo !empty($button['id']) ? 'data-id="' . esc_attr($button['id']) . '"' : '';?>
                                ><?php echo esc_html($button['text']);?></button>
                                <?php
                            }
                            ?>
                        </div>
                    </div>
                    <?php
                }

                ?>
            </div>
            <div class="seoaic-ia-block-answers-wrapper"></div>
        </div>
        <?php
        $html = ob_get_clean();

        return $html;
    }

    public function html(): string
    {
        if (Company::isChurned()) {
            $html = '<p class="seoaic-ia-inactive-message" data-text="' . esc_html__("It seems your company is inactive. To continue using the Interactive Article feature please contact support.", "seoaic") . '"></p>';

        } else {
            $content = html_entity_decode($this->content);
            $content = stripslashes($content);
            // $content = iconv('UTF-8', 'ASCII//TRANSLIT', $content);
            $params = json_decode($content, true);
            $jsonError = json_last_error();

            if ($jsonError !== JSON_ERROR_NONE) {
                return esc_html__('InteractiveArticleBlock broken data:', 'seoaic') . ' JSON error ' . $jsonError;
            }

            $html = $this->makeHTML($params, $this->attrs);
        }

        return $html;
    }
}
