<?php

namespace SEOAIC\seoaic_acf;

abstract class SEOAICCustomField {

    protected $fieldKey;
    protected $fieldName;
    protected $fieldType;

    public function __construct($fieldKey, $fieldName, $fieldType) {
        $this->fieldKey   = $fieldKey;
        $this->fieldName  = $fieldName;
        $this->fieldType  = $fieldType;
    }

    /**
     * @return mixed
     */
    abstract public function registerField();

    /**
     * @param $value
     * @param $postId
     * @param $field
     * @return mixed
     */
    abstract public function loadFieldValue($value, $postId, $field);
}
