<?php

namespace SEOAIC;

use Exception;

class SEOAIC_SENTIMENT_ANALYSIS {
    private $seoaic;

    private string $endpointResult = 'api/sentiment-analysis/list';
    private string $endpointRefresh = 'api/sentiment-analysis/refresh';
    private string $endpointRequest = 'api/sentiment-analysis/request';

    public function __construct( $seoaic ) {
        $this->seoaic = $seoaic;

        add_action( 'wp_ajax_seoaic_sentiment_analysis_result', [ $this, 'getResultAjax' ] );
        add_action( 'wp_ajax_seoaic_sentiment_analysis_refresh', [ $this, 'refreshAjax' ] );
        add_action( 'wp_ajax_seoaic_sentiment_analysis_request', [ $this, 'requestAjax' ] );
    }

    public function getResult () {
        try {
            $result = $this->seoaic->curl->initWithReturn( $this->endpointResult, [], true, true );
            if( !empty( $result['data'] ) )
            return $result['data'];
        } catch ( Exception $e ) {
           return [];
        }
    }


    public function getResultAjax() {
        try {
            $response = $this->seoaic->curl->initWithReturn( $this->endpointResult, [], true, true );
            SEOAICAjaxResponse::success( $response )->wpSend();
        } catch ( Exception $e ) {
            SEOAICAjaxResponse::error( 'Failed to get result: ' . $e->getMessage() )->wpSend();
        }
    }

    public function refreshAjax() {
        global $SEOAIC_OPTIONS;

        $request = [];

        if( !empty ( $SEOAIC_OPTIONS['seoaic_business_name'] ) ){
            $request['company_name'] = $SEOAIC_OPTIONS['seoaic_business_name'];
        }

        if( !empty ( $SEOAIC_OPTIONS['seoaic_language'] ) ){
            $request['language']    = $SEOAIC_OPTIONS['seoaic_language'];
        }

        if( !empty ( $SEOAIC_OPTIONS['seoaic_location'] ) ){
            $request['location']    = $SEOAIC_OPTIONS['seoaic_location'];
        }

        try {
            $response = $this->seoaic->curl->initWithReturn( $this->endpointRefresh, $request, true, true );
            SEOAICAjaxResponse::success( $response )->wpSend();
        } catch ( Exception $e ) {
            SEOAICAjaxResponse::error( 'Failed to refresh: ' . $e->getMessage() )->wpSend();
        }
    }

    public function requestAjax() {
        global $SEOAIC_OPTIONS;

        $request = [];

        if( !empty ( $SEOAIC_OPTIONS['seoaic_business_name'] ) ){
            $request['company_name'] = $SEOAIC_OPTIONS['seoaic_business_name'];
        }

        if( !empty ( $SEOAIC_OPTIONS['seoaic_language'] ) ){
            $request['language']    = $SEOAIC_OPTIONS['seoaic_language'];
        }

        if( !empty ( $SEOAIC_OPTIONS['seoaic_location'] ) ){
            $request['location']    = $SEOAIC_OPTIONS['seoaic_location'];
        }

        try {
            $response = $this->seoaic->curl->initWithReturn( $this->endpointRequest, $request, true, true );
            SEOAICAjaxResponse::success( $response )->wpSend();
        } catch ( Exception $e ) {
            SEOAICAjaxResponse::error( 'Failed to refresh: ' . $e->getMessage() )->wpSend();
        }
    }
}