<?php

class SeoaicAjaxValidation
{
    public const ACTION_STRING = 'seoaic_action_string';

    private $allowed_actions = [
        // 'seoaic_update_company_credits',
        // 'seoaic_get_blog_settings',
    ];

    public function __construct()
    {
        add_action('admin_init', [$this, 'checkAjaxPermissions']);
        add_action('admin_enqueue_scripts', [$this, 'seoaicAdminNonceParams']);
        add_action('enqueue_block_assets', [$this, 'seoaicGutenbergNonceParams']);
    }

    public function checkAjaxPermissions()
    {
        if (!wp_doing_ajax()) {
            return;
        }

        // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $__REQUEST = wp_unslash($_REQUEST);
        $action = isset($__REQUEST['action']) ? $__REQUEST['action'] : '';

        if (
            $this->isSeoaicAction($action)
            && !$this->isActionExcluded($action)
        ) {
            $this->userValidation($action);
            $this->nonceValidation($action);
        }
    }

    private function isSeoaicAction($action)
    {
       return strpos($action, 'seoaic') === 0;
    }

    private function userValidation($action)
    {
        if (!current_user_can('seoaic_edit_plugin')) {
            wp_send_json([
                'status'  => 'alert',
                'message' => esc_html__('Permission denied', 'seoaic'),
            ]);
        }
    }

    private function nonceValidation($action)
    {
        $__REQUEST = wp_unslash($_REQUEST);
        $nonce = isset($__REQUEST['_wpnonce']) ? sanitize_text_field($__REQUEST['_wpnonce']) : false;

        // if (empty($nonce) || !wp_verify_nonce($nonce, $action . '_nonce')) {
        if (empty($nonce) || !wp_verify_nonce($nonce, self::ACTION_STRING)) {
            wp_send_json([
                'status'  => 'alert',
                'message' => esc_html__('Oops! It seems like something went wrong. Please refresh the page and try again. If the issue persists, contact our support team for assistance. Error: Invalid security token.', 'seoaic'),
            ]);
        }
    }

    private function isActionExcluded($action)
    {
        return in_array($action, $this->allowed_actions);
    }

    // private function ajaxNonceActions() {
    //     $nonce_actions = [
    //         'seoaic_get_all_public_posts' => wp_create_nonce('seoaic_get_all_public_posts_nonce'),
    //         'seoaic_get_public_posts' => wp_create_nonce('seoaic_get_public_posts_nonce'),
    //         'seoaic_settings_get_public_seoaic_posts' => wp_create_nonce('seoaic_settings_get_public_seoaic_posts_nonce'),
    //         // 'seoaic_get_keyword_serp' => wp_create_nonce('seoaic_get_keyword_serp_nonce'),
    //         'seoaic_get_child_keywords' => wp_create_nonce('seoaic_get_child_keywords_nonce'),
    //         'seoaic_keywords_track_keyword' => wp_create_nonce('seoaic_keywords_track_keyword_nonce'),
    //         'seoaic_keywords_get_competitor_keywords' => wp_create_nonce('seoaic_keywords_get_competitor_keywords_nonce'),
    //         'seoaic_keywords_get_competitor_keywords_tabs' => wp_create_nonce('seoaic_keywords_get_competitor_keywords_tabs_nonce'),
    //         'seoaicGetCountries' => wp_create_nonce('seoaicGetCountries_nonce'),
    //         'seoaicGetGroupLocation' => wp_create_nonce('seoaicGetGroupLocation_nonce'),
    //         'seoaicUpdateSearchTerms' => wp_create_nonce('seoaicUpdateSearchTerms_nonce'),
    //         'seoaic_send_upgrade_plan' => wp_create_nonce('seoaic_send_upgrade_plan_nonce'),
    //         'seoaic_settings' => wp_create_nonce('seoaic_settings_nonce'),
    //         'seoaic_pillar_links' => wp_create_nonce('seoaic_pillar_links_nonce'),
    //         'seoaic_settings_prompts' => wp_create_nonce('seoaic_settings_prompts_nonce'),
    //         'seoaic_settings_leads_addon_form_save' => wp_create_nonce('seoaic_settings_leads_addon_form_save_nonce'),
    //         'seoaic_settings_generate_description' => wp_create_nonce('seoaic_settings_generate_description_nonce'),
    //         'seoaic_registration' => wp_create_nonce('seoaic_registration_nonce'),
    //         'seoaic_login' => wp_create_nonce('seoaic_login_nonce'),
    //         'seoaic_forgot' => wp_create_nonce('seoaic_forgot_nonce'),
    //         'seoaic_disconnect' => wp_create_nonce('seoaic_disconnect_nonce'),
    //         'seoaic_get_idea_content' => wp_create_nonce('seoaic_get_idea_content_nonce'),
    //         'seoaic_clear_background_option' => wp_create_nonce('seoaic_clear_background_option_nonce'),
    //         'seoaic_add_idea' => wp_create_nonce('seoaic_add_idea_nonce'),

    //         'seoaic_posts_mass_generate_stop' => wp_create_nonce('seoaic_posts_mass_generate_stop_nonce'),
    //         'seoaic_posts_mass_generate_check_status_manually' => wp_create_nonce('seoaic_posts_mass_generate_check_status_manually_nonce'),
    //         'seoaic_schedule_posts' => wp_create_nonce('seoaic_schedule_posts_nonce'),
    //         'seoaic_reschedule_posts' => wp_create_nonce('seoaic_reschedule_posts_nonce'),
    //         'seoaic_posts_mass_create' => wp_create_nonce('seoaic_posts_mass_create_nonce'),

    //         'seoaic_posts_mass_generate_save_prompt_template' => wp_create_nonce('seoaic_posts_mass_generate_save_prompt_template_nonce'),
    //         'seoaic_posts_mass_generate_delete_prompt_template' => wp_create_nonce('seoaic_posts_mass_generate_delete_prompt_template_nonce'),
    //         'seoaic_posts_mass_generate_delete_last_prompt' => wp_create_nonce('seoaic_posts_mass_generate_delete_last_prompt_nonce'),

    //         'seoaic_posts_mass_edit_save_prompt_template' => wp_create_nonce('seoaic_posts_mass_edit_save_prompt_template_nonce'),
    //         'seoaic_posts_mass_edit_delete_prompt_template' => wp_create_nonce('seoaic_posts_mass_edit_delete_prompt_template_nonce'),
    //         'seoaic_posts_mass_edit_delete_last_prompt' => wp_create_nonce('seoaic_posts_mass_edit_delete_last_prompt_nonce'),

    //         'seoaic_posts_mass_review_save_prompt_template' => wp_create_nonce('seoaic_posts_mass_review_save_prompt_template_nonce'),
    //         'seoaic_posts_mass_review_delete_prompt_template' => wp_create_nonce('seoaic_posts_mass_review_delete_prompt_template_nonce'),
    //         'seoaic_posts_mass_review_delete_last_prompt' => wp_create_nonce('seoaic_posts_mass_review_delete_last_prompt_nonce'),

    //         'seoaic_keywords_generate_save_prompt_template' => wp_create_nonce('seoaic_keywords_generate_save_prompt_template_nonce'),
    //         'seoaic_keywords_generate_delete_prompt_template' => wp_create_nonce('seoaic_keywords_generate_delete_prompt_template_nonce'),
    //         'seoaic_keywords_generate_delete_last_prompt' => wp_create_nonce('seoaic_keywords_generate_delete_last_prompt_nonce'),

    //         'seoaic_ideas_generate_save_prompt_template' => wp_create_nonce('seoaic_ideas_generate_save_prompt_template_nonce'),
    //         'seoaic_ideas_generate_delete_prompt_template' => wp_create_nonce('seoaic_ideas_generate_delete_prompt_template_nonce'),
    //         'seoaic_ideas_generate_delete_last_prompt' => wp_create_nonce('seoaic_ideas_generate_delete_last_prompt_nonce'),


    //         'seoaic_posts_mass_edit' => wp_create_nonce('seoaic_posts_mass_edit_nonce'),
    //         'seoaic_posts_mass_edit_check_status' => wp_create_nonce('seoaic_posts_mass_edit_check_status_nonce'),
    //         'seoaic_posts_mass_stop_edit' => wp_create_nonce('seoaic_posts_mass_stop_edit_nonce'),
    //         'seoaic_clear_edit_background_option' => wp_create_nonce('seoaic_clear_edit_background_option_nonce'),

    //         'seoaic_posts_mass_review' => wp_create_nonce('seoaic_posts_mass_review_nonce'),
    //         'seoaic_posts_mass_review_check_status' => wp_create_nonce('seoaic_posts_mass_review_check_status_nonce'),
    //         'seoaic_posts_mass_stop_review' => wp_create_nonce('seoaic_posts_mass_stop_review_nonce'),
    //         'seoaic_clear_review_background_option' => wp_create_nonce('seoaic_clear_review_background_option_nonce'),

    //         'seoaic_posts_mass_translate' => wp_create_nonce('seoaic_posts_mass_translate_nonce'),
    //         'seoaic_posts_mass_translate_check_status' => wp_create_nonce('seoaic_posts_mass_translate_check_status_nonce'),
    //         'seoaic_posts_mass_thumbnails_generate_check_status' => wp_create_nonce('seoaic_posts_mass_thumbnails_generate_check_status_nonce'),

    //         'seoaic_mass_posts_edit_undo' => wp_create_nonce('seoaic_mass_posts_edit_undo_nonce'),

    //         'seoaic_edit_idea' => wp_create_nonce('seoaic_edit_idea_nonce'),
    //         'seoaic_remove_idea' => wp_create_nonce('seoaic_remove_idea_nonce'),
    //         'seoaic_generate_skeleton' => wp_create_nonce('seoaic_generate_skeleton_nonce'),
    //         'seoaic_save_content_idea' => wp_create_nonce('seoaic_save_content_idea_nonce'),
    //         'seoaic_improve_ideas' => wp_create_nonce('seoaic_improve_ideas_nonce'),
    //         'seoaic_frames_mass_generate' => wp_create_nonce('seoaic_frames_mass_generate_nonce'),
    //         'seoaic_frames_mass_generate_check_status' => wp_create_nonce('seoaic_frames_mass_generate_check_status_nonce'),

    //         'seoaic_add_keyword' => wp_create_nonce('seoaic_add_keyword_nonce'),

    //         'seoaic_get_head_keywords' => wp_create_nonce('seoaic_get_head_keywords_nonce'),
    //         'seoaic_edit_generated_keyword' => wp_create_nonce('seoaic_edit_generated_keyword_nonce'),
    //         'seoaic_update_keywords' => wp_create_nonce('seoaic_update_keywords_nonce'),
    //         'seoaic_remove_keyword' => wp_create_nonce('seoaic_remove_keyword_nonce'),
    //         'seoaic_remove_and_reassign_keyword' => wp_create_nonce('seoaic_remove_and_reassign_keyword_nonce'),
    //         'seoaic_keywords_get_siblings_keywords' => wp_create_nonce('seoaic_keywords_get_siblings_keywords_nonce'),
    //         'seoaic_keywords_poll_rank_data' => wp_create_nonce('seoaic_keywords_poll_rank_data_nonce'),
    //         'seoaic_keywords_category_add' => wp_create_nonce('seoaic_keywords_category_add_nonce'),
    //         'seoaic_keywords_get_categories' => wp_create_nonce('seoaic_keywords_get_categories_nonce'),
    //         'seoaic_keywords_update_category' => wp_create_nonce('seoaic_keywords_update_category_nonce'),
    //         'seoaic_keywords_delete_category' => wp_create_nonce('seoaic_keywords_delete_category_nonce'),
    //         'seoaic_keywords_set_category' => wp_create_nonce('seoaic_keywords_set_category_nonce'),
    //         'seoaic_set_keyword_link' => wp_create_nonce('seoaic_set_keyword_link_nonce'),
    //         'seoaic_keyword_get_created_ideas' => wp_create_nonce('seoaic_keyword_get_created_ideas_nonce'),
    //         'seoaic_keyword_get_created_posts' => wp_create_nonce('seoaic_keyword_get_created_posts_nonce'),
    //         'seoaic_set_keyword_location' => wp_create_nonce('seoaic_set_keyword_location_nonce'),
    //         'seoaic_migrate_terms_to_keywords' => wp_create_nonce('seoaic_migrate_terms_to_keywords_nonce'),
    //         'seoaic_get_keyword_internal_links_all' => wp_create_nonce('seoaic_get_keyword_internal_links_all_nonce'),
    //         'seoaic_get_keyword_internal_links_recommended' => wp_create_nonce('seoaic_get_keyword_internal_links_recommended_nonce'),
    //         'seoaic_get_internal_links_random' => wp_create_nonce('seoaic_get_internal_links_random_nonce'),

    //         'seoaic_get_locations' => wp_create_nonce('seoaic_get_locations_nonce'),
    //         'seoaic_get_location_languages' => wp_create_nonce('seoaic_get_location_languages_nonce'),
    //         'seoaic_get_language_locations' => wp_create_nonce('seoaic_get_language_locations_nonce'),

    //         'seoaicDeleteGroupLocation' => wp_create_nonce('seoaicDeleteGroupLocation_nonce'),
    //         'seoaicSaveLocationGroup' => wp_create_nonce('seoaicSaveLocationGroup_nonce'),
    //         // 'seoaicAddSearchTerms' => wp_create_nonce('seoaicAddSearchTerms_nonce'),
    //         'seoaicRemoveSearchTerms' => wp_create_nonce('seoaicRemoveSearchTerms_nonce'),
    //         'seoaic_get_search_term_competitors' => wp_create_nonce('seoaic_get_search_term_competitors_nonce'),
    //         // 'seoaicGetKeywordSuggestions' => wp_create_nonce('seoaicGetKeywordSuggestions_nonce'),
    //         'seoaicAddedCompetitors' => wp_create_nonce('seoaicAddedCompetitors_nonce'),
    //         'seoaic_add_competitor_location' => wp_create_nonce('seoaic_add_competitor_location_nonce'),
    //         'seoaic_remove_competitor_location' => wp_create_nonce('seoaic_remove_competitor_location_nonce'),
    //         'seoaic_insert_my_competitor_term' => wp_create_nonce('seoaic_insert_my_competitor_term_nonce'),
    //         'seoaic_location_tabs_sorting' => wp_create_nonce('seoaic_location_tabs_sorting_nonce'),
    //         'seoaic_get_keywords_options' => wp_create_nonce('seoaic_get_keywords_options_nonce'),
    //         // 'seoaic_competitors_keywords_ranks_timeline' => wp_create_nonce('seoaic_competitors_keywords_ranks_timeline_nonce'),
    //         'seoaicAddGroupLocation' => wp_create_nonce('seoaicAddGroupLocation_nonce'),
    //         'seoaicRenameGroupLocation' => wp_create_nonce('seoaicRenameGroupLocation_nonce'),
    //         'seoaic_generate_ideas' => wp_create_nonce('seoaic_generate_ideas_nonce'),
    //         'seoaic_generate_ideas_new_keywords' => wp_create_nonce('seoaic_generate_ideas_new_keywords_nonce'),
    //         'seoaic_generate_keywords_prompt' => wp_create_nonce('seoaic_generate_keywords_prompt_nonce'),
    //         'seoaicAddSubTerms' => wp_create_nonce('seoaicAddSubTerms_nonce'),
    //         'seoaic_publish_post' => wp_create_nonce('seoaic_publish_post_nonce'),
    //         'seoaic_regenerate_image' => wp_create_nonce('seoaic_regenerate_image_nonce'),
    //         'seoaic_setinfo' => wp_create_nonce('seoaic_setinfo_nonce'),
    //         'seoaic_remove_idea_posting_date' => wp_create_nonce('seoaic_remove_idea_posting_date_nonce'),
    //         'seoaic_improve_post' => wp_create_nonce('seoaic_improve_post_nonce'),
    //         // 'seoaicLocationsOptions' => wp_create_nonce('seoaicLocationsOptions_nonce'),
    //         // 'seoaic_generate_post' => wp_create_nonce('seoaic_generate_post_nonce'),
    //         'seoaic_getCategoriesOfPosttype' => wp_create_nonce('seoaic_getCategoriesOfPosttype_nonce'),
    //         'seoaic_selectCategoriesIdea' => wp_create_nonce('seoaic_selectCategoriesIdea_nonce'),
    //         'seoaic_Update_credits_real_time' => wp_create_nonce('seoaic_Update_credits_real_time_nonce'),
    //         // 'seoaic_Get_on_page_seo_data' => wp_create_nonce('seoaic_Get_on_page_seo_data_nonce'),
    //         'seoaic_transform_idea' => wp_create_nonce('seoaic_transform_idea_nonce'),
    //         'seoaic_get_knowledge_base_list' => wp_create_nonce('seoaic_get_knowledge_base_list_nonce'),
    //         'seoaic_create_knowledge_base' => wp_create_nonce('seoaic_create_knowledge_base_nonce'),
    //         'seoaic_wizard_generate_keywords' => wp_create_nonce('seoaic_wizard_generate_keywords_nonce'),
    //         'seoaic_wizard_reload_entities' => wp_create_nonce('seoaic_wizard_reload_entities_nonce'),
    //         'seoaic_wizard_step_back' => wp_create_nonce('seoaic_wizard_step_back_nonce'),
    //         'seoaic_wizard_select_keywords' => wp_create_nonce('seoaic_wizard_select_keywords_nonce'),
    //         'seoaic_wizard_generate_ideas' => wp_create_nonce('seoaic_wizard_generate_ideas_nonce'),
    //         'seoaic_wizard_posts_mass_create' => wp_create_nonce('seoaic_wizard_posts_mass_create_nonce'),
    //         'seoaic_wizard_reset' => wp_create_nonce('seoaic_wizard_reset_nonce'),
    //         'seoaic_Add_New_Competitor' => wp_create_nonce('seoaic_Add_New_Competitor_nonce'),
    //         'seoaic_remove_competitor' => wp_create_nonce('seoaic_remove_competitor_nonce'),
    //         'seoaic_Competitors_Compare_Section_HTML' => wp_create_nonce('seoaic_Competitors_Compare_Section_HTML_nonce'),
    //         'seoaic_Competitors_Search_Terms_HTML' => wp_create_nonce('seoaic_Competitors_Search_Terms_HTML_nonce'),
    //         'seoaic_Remove_Term' => wp_create_nonce('seoaic_Remove_Term_nonce'),
    //         // 'seoaic_Get_My_Rank_Search_Term' => wp_create_nonce('seoaic_Get_My_Rank_Search_Term_nonce'),
    //         'seoaic_Generate_Article_Based_Search_Term' => wp_create_nonce('seoaic_Generate_Article_Based_Search_Term_nonce'),
    //         'seoaic_Prepare_Article_Based_Search_Term' => wp_create_nonce('seoaic_Prepare_Article_Based_Search_Term_nonce'),
    //         'seoaic_Check_Terms_Update_Progress' => wp_create_nonce('seoaic_Check_Terms_Update_Progress_nonce'),
    //         // 'seoaicAddCompetitorsTerms' => wp_create_nonce('seoaicAddCompetitorsTerms_nonce'),
    //         'seoaic_compare_other_positions' => wp_create_nonce('seoaic_compare_other_positions_nonce'),
    //         'seoaic_compare_my_article' => wp_create_nonce('seoaic_compare_my_article_nonce'),
    //         'seoaic_compare_my_competitors' => wp_create_nonce('seoaic_compare_my_competitors_nonce'),
    //         'seoaic_compare_analysis' => wp_create_nonce('seoaic_compare_analysis_nonce'),
    //         'seoaic_get_top_google_analysis' => wp_create_nonce('seoaic_get_top_google_analysis_nonce'),
    //         'seoaic_Progress_Values' => wp_create_nonce('seoaic_Progress_Values_nonce'),
    //         'seoaic_get_seo_audit_data' => wp_create_nonce('seoaic_get_seo_audit_data_nonce'),
    //         'seoaic_create_seo_audit' => wp_create_nonce('seoaic_create_seo_audit_nonce'),
    //         'seoaic_get_page_speed_analysis' => wp_create_nonce('seoaic_get_page_speed_analysis_nonce'),
    //         'seoaic_get_lighthouse_dates_html' => wp_create_nonce('seoaic_get_lighthouse_dates_html_nonce'),
    //         'seoaic_get_all_site_links' => wp_create_nonce('seoaic_get_all_site_links_nonce'),
    //         'seoaic_remove_knowledge_base' => wp_create_nonce('seoaic_remove_knowledge_base_nonce'),
    //         'seoaic_save_knowledge_base_data_sources' => wp_create_nonce('seoaic_save_knowledge_base_data_sources_nonce'),
    //         'seoaic_get_data_sources_list' => wp_create_nonce('seoaic_get_data_sources_list_nonce'),
    //         'seoaic_rerun_data_source' => wp_create_nonce('seoaic_rerun_data_source_nonce'),
    //         'seoaic_remove_data_source' => wp_create_nonce('seoaic_remove_data_source_nonce'),
    //         'seoaic_train_data_source' => wp_create_nonce('seoaic_train_data_source_nonce'),
    //         'seoaic_train_knowledge_base' => wp_create_nonce('seoaic_train_knowledge_base_nonce'),
    //         'seoaic_rerun_knowledge_base' => wp_create_nonce('seoaic_rerun_knowledge_base_nonce'),
    //         'seoaic_get_crawled_pages' => wp_create_nonce('seoaic_get_crawled_pages_nonce'),
    //         'seoaic_rerun_sources' => wp_create_nonce('seoaic_rerun_sources_nonce'),
    //         'seoaic_remove_sources' => wp_create_nonce('seoaic_remove_sources_nonce'),
    //         // 'seoaicFilteringTerms' => wp_create_nonce('seoaicFilteringTerms_nonce'),
    //         'seoaic_update_competitor_data' => wp_create_nonce('seoaic_update_competitor_data_nonce'),
    //         'seoaic_my_article_popup_top_table_analysis' => wp_create_nonce('seoaic_my_article_popup_top_table_analysis_nonce'),
    //         'seoaic_competitor_article_popup_table_analysis' => wp_create_nonce('seoaic_competitor_article_popup_table_analysis_nonce'),
    //         'seoaic_get_content_improvement_section_html' => wp_create_nonce('seoaic_get_content_improvement_section_html_nonce'),
    //         'seoaic_get_automated_suggestions_section' => wp_create_nonce('seoaic_get_automated_suggestions_section_nonce'),
    //         'seoaic_automated_improvement_content_single_tag' => wp_create_nonce('seoaic_automated_improvement_content_single_tag_nonce'),
    //         'seoaic_automated_improvement_content_section' => wp_create_nonce('seoaic_automated_improvement_content_section_nonce'),
    //         'seoaic_automated_suggestion_action' => wp_create_nonce('seoaic_automated_suggestion_action_nonce'),
    //         'seoaic_automated_suggestions_check_status' => wp_create_nonce('seoaic_automated_suggestions_check_status_nonce'),
    //         'seoaic_automated_suggestions_stop_polling' => wp_create_nonce('seoaic_automated_suggestions_stop_polling_nonce'),
    //         'seoaic_data_improvements_load_job' => wp_create_nonce('seoaic_data_improvements_load_job_nonce'),
    //         'seoaic_improvements_add_to_queue' => wp_create_nonce('seoaic_improvements_add_to_queue_nonce'),
    //         'seoaic_clear_analysis_queue' => wp_create_nonce('seoaic_clear_analysis_queue_nonce'),
    //         'seoaic_seo_meta_improvement_modal_html' => wp_create_nonce('seoaic_seo_meta_improvement_modal_html_nonce'),
    //         'seoaic_set_new_seo_data' => wp_create_nonce('seoaic_set_new_seo_data_nonce'),
    //         'seoaic_edit_seo_data_preview' => wp_create_nonce('seoaic_edit_seo_data_preview_nonce'),
    //         'seoaic_generate_improvement_text' => wp_create_nonce('seoaic_generate_improvement_text_nonce'),
    //         'seoaic_add_manually_improvement_text' => wp_create_nonce('seoaic_add_manually_improvement_text_nonce'),
    //         'seoaic_settings_get_post_type_templates' => wp_create_nonce('seoaic_settings_get_post_type_templates_nonce'),
    //         'seoaic_settings_content_alerts_save' => wp_create_nonce('seoaic_settings_content_alerts_save_nonce'),
    //         'seoaic_drafts_queue' => wp_create_nonce('seoaic_drafts_queue_nonce'),
    //         'seoaic_sort_auto_scheduled_drafts' => wp_create_nonce('seoaic_sort_auto_scheduled_drafts_nonce'),
    //         'seoaic_save_knowledge_base' => wp_create_nonce('seoaic_save_knowledge_base_nonce'),
    //         'seoaic_get_keyword_competitors' => wp_create_nonce('seoaic_get_keyword_competitors_nonce'),
    //         'seoaic_get_page_analyze' => wp_create_nonce('seoaic_get_page_analyze_nonce'),
    //         'seoaic_get_ai_suggestions' => wp_create_nonce('seoaic_get_ai_suggestions_nonce'),
    //         'seoaic_clean_serp_data' => wp_create_nonce('seoaic_clean_serp_data_nonce'),
    //         'seoaic_redirect' => wp_create_nonce('seoaic_redirect_nonce'),
    //         'seoaic_validate_positions_real_terms_count' => wp_create_nonce('seoaic_validate_positions_real_terms_count_nonce'),
    //         'seoaic_restore_post' => wp_create_nonce('seoaic_restore_post_nonce'),
    //         'seoaic_bulk_restore_post' => wp_create_nonce('seoaic_bulk_restore_post_nonce'),
    //         'seoaic_add_site_to_google_console' => wp_create_nonce('seoaic_add_site_to_google_console_nonce'),
    //         'seoaic_compare_competitors' => wp_create_nonce('seoaic_compare_competitors_nonce'),
    //         'seoaic_compare_competitors_term' => wp_create_nonce('seoaic_compare_competitors_term_nonce'),
    //         'seoaic_migrate_competitors_from_options' => wp_create_nonce('seoaic_migrate_competitors_from_options_nonce'),
    //         'seoaic_train_data_source_item' => wp_create_nonce('seoaic_train_data_source_item_nonce'),
    //         'seoaic_get_data_for_pruning_chart' => wp_create_nonce('seoaic_get_data_for_pruning_chart_nonce'),
    //         'seoaic_dashboard_counters' => wp_create_nonce('seoaic_dashboard_counters_nonce'),
    //         'seoaic_remove_post_to_trash' => wp_create_nonce('seoaic_remove_post_to_trash_nonce'),
    //         'seoaic_posts_set_mass_thumbnail' => wp_create_nonce('seoaic_posts_set_mass_thumbnail_nonce'),
    //         'seoaic_set_posts_status' => wp_create_nonce('seoaic_set_posts_status_nonce'),
    //         'seoaic_content_imptovement_get_pages' => wp_create_nonce('seoaic_content_imptovement_get_pages_nonce'),
    //         'seoaic_pillar_links_tracked' => wp_create_nonce('seoaic_pillar_links_tracked_nonce'),
    //         'seoaic_activate_pillar_links' => wp_create_nonce('seoaic_activate_pillar_links_nonce'),
    //         'seoaic_ranking_get_pages' => wp_create_nonce('seoaic_ranking_get_pages_nonce'),
    //         'seoaic_get_keywords_for_page' => wp_create_nonce('seoaic_get_keywords_for_page_nonce'),
    //         'seoaic_get_data_for_keywords_chart' => wp_create_nonce('seoaic_get_data_for_keywords_chart_nonce'),
    //         'seoaic_seoaic_automated_pruning_pages' => wp_create_nonce('seoaic_seoaic_automated_pruning_pages_nonce'),
    //         'seoaic_keyword_cannibalisation_pages' => wp_create_nonce('seoaic_keyword_cannibalisation_pages_nonce'),
    //         'seoaic_get_keywords_results' => wp_create_nonce('seoaic_get_keywords_results_nonce'),
    //         'seoaic_get_questions_words' => wp_create_nonce('seoaic_get_questions_words_nonce'),
    //         'seoaic_update_post_visibility' => wp_create_nonce('seoaic_update_post_visibility_nonce'),
    //         'seoaic_get_calendar_draft_posts' => wp_create_nonce('seoaic_get_calendar_draft_posts_nonce'),
    //         'seoaic_get_calendar_scheduled_posts' => wp_create_nonce('seoaic_get_calendar_scheduled_posts_nonce'),
    //         // 'seoaic_update_calendar_posts' => wp_create_nonce('seoaic_update_calendar_posts_nonce'),
    //         'seoaic_mass_suggestion' => wp_create_nonce('seoaic_mass_suggestion_nonce'),
    //         'seoaic_comparison_pages' => wp_create_nonce('seoaic_comparison_pages_nonce'),
    //         'seoaic_keyword_analysation_pages' => wp_create_nonce('seoaic_keyword_analysation_pages_nonce'),
    //         'seoaic_verify_gsc_integration' => wp_create_nonce('seoaic_verify_gsc_integration_nonce'),
    //         'seoaic_check_broken_links' => wp_create_nonce('seoaic_check_broken_links_nonce'),
    //         'seoaic_get_links_from_content' => wp_create_nonce('seoaic_get_links_from_content_nonce'),
    //         'seoaic_generate_ai_summary_content' => wp_create_nonce('seoaic_generate_ai_summary_content_nonce'),
    //         'seoaic_get_promote_media_list' => wp_create_nonce('seoaic_get_promote_media_list_nonce'),
    //         'seoaic_send_to_promote' => wp_create_nonce('seoaic_send_to_promote_nonce'),
    //         'seoaic_content_improvement_post' => wp_create_nonce('seoaic_content_improvement_post_nonce'),
    //         // 'seoaic_custom_content_improvement' => wp_create_nonce('seoaic_custom_content_improvement_nonce'),
    //         'seoaic_replace_content_block' => wp_create_nonce('seoaic_replace_content_block_nonce'),
    //         'seoaic_proccess_onboarding_step' => wp_create_nonce('seoaic_proccess_onboarding_step_nonce'),
    //         'seoaic_onboarding_scan_pages' => wp_create_nonce('seoaic_onboarding_scan_pages_nonce'),
    //         'seoaic_onboarding_check_status' => wp_create_nonce('seoaic_onboarding_check_status_nonce'),
    //         'seoaic_onboarding_get_clusters_list' => wp_create_nonce('seoaic_onboarding_get_clusters_list_nonce'),
    //         'seoaic_onboarding_get_services_and_audience' => wp_create_nonce('seoaic_onboarding_get_services_and_audience_nonce'),
    //         'seoaic_onboarding_get_ideas' => wp_create_nonce('seoaic_onboarding_get_ideas_nonce'),
    //         'seoaic_onboarding_cluster_ideas_generate' => wp_create_nonce('seoaic_onboarding_cluster_ideas_generate_nonce'),
    //         // 'seoaic_onboarding_add_idea_to_cluster' => wp_create_nonce('seoaic_onboarding_add_idea_to_cluster_nonce'),
    //         'seoaic_onboarding_cluster_ideas_remove' => wp_create_nonce('seoaic_onboarding_cluster_ideas_remove_nonce'),
    //         'seoaic_onboarding_cluster_ideas_update' => wp_create_nonce('seoaic_onboarding_cluster_ideas_update_nonce'),
    //         'seoaic_clusters_get_gsc_stat' => wp_create_nonce('seoaic_clusters_get_gsc_stat_nonce'),
    //         'seoaic_cluster_update' => wp_create_nonce('seoaic_cluster_update_nonce'),
    //         'seoaic_cluster_delete' => wp_create_nonce('seoaic_cluster_delete_nonce'),
    //         'seoaic_onboarding_step' => wp_create_nonce('seoaic_onboarding_step_nonce'),
    //         'seoaic_save_services' => wp_create_nonce('seoaic_save_services_nonce'),
    //         'seoaic_create_cluster' => wp_create_nonce('seoaic_create_cluster_nonce'),
    //         'seoaic_add_page_to_cluster' => wp_create_nonce('seoaic_add_page_to_cluster_nonce'),
    //         'seoaic_remove_page_from_cluster' => wp_create_nonce('seoaic_remove_page_from_cluster_nonce'),
    //         'seoaic_clear_onboarding_progress' => wp_create_nonce('seoaic_clear_onboarding_progress_nonce'),
    //         'seoaic_onboarding_google_integration_check' => wp_create_nonce('seoaic_onboarding_google_integration_check_nonce'),
    //         'seoaic_onboarding_content_strategy_html' => wp_create_nonce('seoaic_onboarding_content_strategy_html_nonce'),
    //         'seoaic_get_onboarding_schedule_ideas' => wp_create_nonce('seoaic_get_onboarding_schedule_ideas_nonce'),
    //         'seoaic_onboarding_init_posts_publish' => wp_create_nonce('seoaic_onboarding_init_posts_publish_nonce'),
    //         'seoaic_dashboard_leads_export' => wp_create_nonce('seoaic_dashboard_leads_export_nonce'),
    //         'seoaic_load_post_content_to_editor' => wp_create_nonce('seoaic_load_post_content_to_editor_nonce'),
    //     ];

    //     return $nonce_actions;
    // }

    private function ajaxNonceActionsNew() {
        $nonce_actions = [
            'seoaic_get_all_public_posts'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_all_public_posts_by_title_or_slug' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_public_posts'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_settings_get_public_seoaic_posts'   => wp_create_nonce(self::ACTION_STRING),

            'seoaicGetCountries'                        => wp_create_nonce(self::ACTION_STRING),
            // 'seoaicLocationsOptions'                    => wp_create_nonce(self::ACTION_STRING),
            'seoaicAddGroupLocation'                    => wp_create_nonce(self::ACTION_STRING),
            'seoaicDeleteGroupLocation'                 => wp_create_nonce(self::ACTION_STRING),
            'seoaicRenameGroupLocation'                 => wp_create_nonce(self::ACTION_STRING),
            'seoaicGetGroupLocation'                    => wp_create_nonce(self::ACTION_STRING),
            'seoaicSaveLocationGroup'                   => wp_create_nonce(self::ACTION_STRING),

            // 'seoaicUpdateSearchTerms'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_send_upgrade_plan'                  => wp_create_nonce(self::ACTION_STRING),

            'seoaic_settings'                           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_pillar_links'                       => wp_create_nonce(self::ACTION_STRING),
            'seoaic_settings_prompts'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_settings_leads_addon_form_save'     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_settings_custom_template_save'      => wp_create_nonce(self::ACTION_STRING),
            'seoaic_settings_generate_description'      => wp_create_nonce(self::ACTION_STRING),
            'seoaic_registration'                       => wp_create_nonce(self::ACTION_STRING),
            'seoaic_login'                              => wp_create_nonce(self::ACTION_STRING),
            'seoaic_forgot'                             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_disconnect'                         => wp_create_nonce(self::ACTION_STRING),
            'seoaic_clear_background_option'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_settings_content_alerts_save'       => wp_create_nonce(self::ACTION_STRING),
            'seoaic_drafts_queue'                       => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sort_auto_scheduled_drafts'         => wp_create_nonce(self::ACTION_STRING),
            'seoaic_setinfo'                            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_settings_get_post_type_templates'   => wp_create_nonce(self::ACTION_STRING),

            'seoaic_get_head_keywords'                  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_update_keywords'                    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_edit_generated_keyword'             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_generate_keywords_prompt'           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_add_keyword'                        => wp_create_nonce(self::ACTION_STRING),
            'seoaic_set_keyword_link'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_remove_keyword'                     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_remove_and_reassign_keyword'        => wp_create_nonce(self::ACTION_STRING),
            // 'seoaic_get_keyword_serp'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_child_keywords'                 => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keywords_get_siblings_keywords'     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keywords_category_add'              => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keywords_get_categories'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keywords_update_category'           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keywords_delete_category'           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keywords_set_category'              => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keywords_poll_rank_data'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keyword_get_created_ideas'          => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keyword_get_created_posts'          => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keywords_track_keyword'             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keywords_get_competitor_keywords'   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keywords_get_competitor_keywords_tabs' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_set_keyword_location'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_migrate_terms_to_keywords'          => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_keyword_internal_links_all'     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_keyword_internal_links_recommended' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_internal_links_random'          => wp_create_nonce(self::ACTION_STRING),

            'seoaic_add_idea'                           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_edit_idea'                          => wp_create_nonce(self::ACTION_STRING),
            'seoaic_remove_idea'                        => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_idea_content'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_save_content_idea'                  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_remove_idea_posting_date'           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_generate_ideas'                     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_generate_ideas_new_keywords'        => wp_create_nonce(self::ACTION_STRING),
            'seoaic_Update_credits_real_time'           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_improve_ideas'                      => wp_create_nonce(self::ACTION_STRING),
            'seoaic_generate_skeleton'                  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_frames_mass_generate'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_frames_mass_generate_check_status'  => wp_create_nonce(self::ACTION_STRING),

            'seoaic_posts_mass_generate_stop'           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_generate_check_status'   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_generate_check_status_manually' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_schedule_posts'                     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_reschedule_posts'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_create'                  => wp_create_nonce(self::ACTION_STRING),

            'seoaic_posts_mass_generate_save_prompt_template'   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_generate_delete_prompt_template' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_generate_delete_last_prompt'     => wp_create_nonce(self::ACTION_STRING),

            'seoaic_posts_mass_edit_save_prompt_template'       => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_edit_delete_prompt_template'     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_edit_delete_last_prompt'         => wp_create_nonce(self::ACTION_STRING),

            'seoaic_posts_mass_review_save_prompt_template'     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_review_delete_prompt_template'   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_review_delete_last_prompt'       => wp_create_nonce(self::ACTION_STRING),

            'seoaic_keywords_generate_save_prompt_template'     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keywords_generate_delete_prompt_template'   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keywords_generate_delete_last_prompt'       => wp_create_nonce(self::ACTION_STRING),

            'seoaic_ideas_generate_save_prompt_template'        => wp_create_nonce(self::ACTION_STRING),
            'seoaic_ideas_generate_delete_prompt_template'      => wp_create_nonce(self::ACTION_STRING),
            'seoaic_ideas_generate_delete_last_prompt'          => wp_create_nonce(self::ACTION_STRING),


            'seoaic_posts_mass_edit'                    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_edit_check_status'       => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_stop_edit'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_clear_edit_background_option'       => wp_create_nonce(self::ACTION_STRING),

            'seoaic_posts_mass_review'                  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_review_check_status'     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_stop_review'             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_clear_review_background_option'     => wp_create_nonce(self::ACTION_STRING),

            'seoaic_posts_mass_translate'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_translate_check_status'  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_translate_stop'          => wp_create_nonce(self::ACTION_STRING),

            'seoaic_posts_mass_thumbnails_generate_check_status'    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_mass_thumbnails_generate_stop'            => wp_create_nonce(self::ACTION_STRING),

            'seoaic_mass_posts_edit_undo'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_regenerate_image'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_publish_post'                       => wp_create_nonce(self::ACTION_STRING),
            'seoaic_posts_set_mass_thumbnail'           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_getCategoriesOfPosttype'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_selectCategoriesIdea'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_transform_idea'                     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_remove_post_to_trash'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_set_posts_status'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_update_post_visibility'             => wp_create_nonce(self::ACTION_STRING),

            'seoaic_wizard_step_back'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_wizard_generate_keywords'           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_wizard_reload_entities'             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_wizard_select_keywords'             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_wizard_generate_ideas'              => wp_create_nonce(self::ACTION_STRING),
            'seoaic_wizard_posts_mass_create'           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_wizard_reset'                       => wp_create_nonce(self::ACTION_STRING),

            'seoaic_generate_lead_form'                 => wp_create_nonce(self::ACTION_STRING),
            'seoaic_generate_lead_form_check_status'    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_generate_lead_form_stop'            => wp_create_nonce(self::ACTION_STRING),

            'seoaic_Add_New_Competitor'                 => wp_create_nonce(self::ACTION_STRING),
            'seoaic_location_tabs_sorting'              => wp_create_nonce(self::ACTION_STRING),
            'seoaic_insert_my_competitor_term'          => wp_create_nonce(self::ACTION_STRING),
            'seoaic_add_competitor_location'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_remove_competitor_location'         => wp_create_nonce(self::ACTION_STRING),
            'seoaic_remove_competitor'                  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_Remove_Term'                        => wp_create_nonce(self::ACTION_STRING),
            'seoaic_Competitors_Compare_Section_HTML'   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_Competitors_Search_Terms_HTML'      => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_keywords_options'               => wp_create_nonce(self::ACTION_STRING),
            // 'seoaic_competitors_keywords_ranks_timeline' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_Check_Terms_Update_Progress'        => wp_create_nonce(self::ACTION_STRING),
            'seoaic_Progress_Values'                    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_Prepare_Article_Based_Search_Term'  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_update_competitor_data'             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_validate_positions_real_terms_count' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_compare_competitors'                => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_top_google_analysis'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_migrate_competitors_from_options'   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_compare_my_article'                 => wp_create_nonce(self::ACTION_STRING),
            'seoaic_compare_my_competitors'             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_compare_analysis'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_compare_other_positions'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_search_term_competitors'        => wp_create_nonce(self::ACTION_STRING),
            'seoaic_my_article_popup_top_table_analysis' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_competitor_article_popup_table_analysis' => wp_create_nonce(self::ACTION_STRING),
            'seoaicAddedCompetitors'                    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_competitors_refresh_manual'         => wp_create_nonce(self::ACTION_STRING),

            'seoaic_get_locations'                      => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_location_languages'             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_language_locations'             => wp_create_nonce(self::ACTION_STRING),

            'seoaic_redirect'                           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_restore_post'                       => wp_create_nonce(self::ACTION_STRING),
            // 'seoaic_bulk_restore_post'                  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_add_site_to_google_console'         => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_data_for_pruning_chart'         => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_keyword_competitors'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_content_improvement_section_html' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_improvements_add_to_queue'          => wp_create_nonce(self::ACTION_STRING),
            'seoaic_generate_improvement_text'          => wp_create_nonce(self::ACTION_STRING),
            'seoaic_add_manually_improvement_text'      => wp_create_nonce(self::ACTION_STRING),
            'seoaic_data_improvements_load_job'         => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_automated_suggestions_section'  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_automated_improvement_content_section' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_automated_improvement_content_single_tag' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_automated_suggestions_check_status' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_automated_suggestions_stop_polling' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_automated_suggestion_action'        => wp_create_nonce(self::ACTION_STRING),
            'seoaic_seo_meta_improvement_modal_html'    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_set_new_seo_data'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_edit_seo_data_preview'              => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_page_analyze'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_ai_suggestions'                 => wp_create_nonce(self::ACTION_STRING),
            'seoaic_clean_serp_data'                    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_clear_analysis_queue'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_content_imptovement_get_pages'      => wp_create_nonce(self::ACTION_STRING),
            'seoaic_ranking_get_pages'                  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_keywords_for_page'              => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_data_for_keywords_chart'        => wp_create_nonce(self::ACTION_STRING),
            'seoaic_seoaic_automated_pruning_pages'     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keyword_cannibalisation_pages'      => wp_create_nonce(self::ACTION_STRING),
            'seoaic_mass_suggestion'                    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_comparison_pages'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_keyword_analysation_pages'          => wp_create_nonce(self::ACTION_STRING),
            'seoaic_verify_gsc_integration'             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_check_broken_links'                 => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_links_from_content'             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_content_improvement_post'           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_replace_content_block'              => wp_create_nonce(self::ACTION_STRING),

            'seoaic_onboarding_scan_pages'              => wp_create_nonce(self::ACTION_STRING),
            'seoaic_onboarding_check_status'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_onboarding_get_clusters_list'       => wp_create_nonce(self::ACTION_STRING),
            'seoaic_onboarding_get_ideas'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_onboarding_cluster_ideas_generate'  => wp_create_nonce(self::ACTION_STRING),
            // 'seoaic_onboarding_add_idea_to_cluster'     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_onboarding_cluster_ideas_remove'    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_onboarding_cluster_ideas_update'    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_onboarding_get_services_and_audience' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_clusters_get_gsc_stat'              => wp_create_nonce(self::ACTION_STRING),
            'seoaic_cluster_update'                     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_cluster_delete'                     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_create_cluster'                     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_remove_page_from_cluster'           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_onboarding_step'                    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_save_services'                      => wp_create_nonce(self::ACTION_STRING),
            'seoaic_add_page_to_cluster'                => wp_create_nonce(self::ACTION_STRING),
            'seoaic_clear_onboarding_progress'          => wp_create_nonce(self::ACTION_STRING),
            'seoaic_onboarding_google_integration_check' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_onboarding_content_strategy_html'   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_onboarding_schedule_ideas'      => wp_create_nonce(self::ACTION_STRING), // ---
            'seoaic_onboarding_init_posts_publish'      => wp_create_nonce(self::ACTION_STRING),
            'seoaic_load_post_content_to_editor'        => wp_create_nonce(self::ACTION_STRING),
            'seoaic_onboarding_accept_ideas'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_load_post_editor_html'              => wp_create_nonce(self::ACTION_STRING),
            'seoaic_ob_load_generated_posts_html'       => wp_create_nonce(self::ACTION_STRING),
            'seoaic_ob_save_and_accept_post'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_ob_save_and_accept_mass_posts'      => wp_create_nonce(self::ACTION_STRING),
            'seoaic_ob_view_remote_ideas'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_all_clustered_posts_batched'    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_posted_date_range'              => wp_create_nonce(self::ACTION_STRING),

            'seoaic_improve_post'                       => wp_create_nonce(self::ACTION_STRING),

            'seoaic_get_knowledge_base_list'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_create_knowledge_base'              => wp_create_nonce(self::ACTION_STRING),
            'seoaic_save_knowledge_base'                => wp_create_nonce(self::ACTION_STRING),
            'seoaic_remove_knowledge_base'              => wp_create_nonce(self::ACTION_STRING),
            'seoaic_save_knowledge_base_data_sources'   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_data_sources_list'              => wp_create_nonce(self::ACTION_STRING),
            'seoaic_rerun_data_source'                  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_remove_data_source'                 => wp_create_nonce(self::ACTION_STRING),
            'seoaic_train_data_source'                  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_train_data_source_item'             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_train_knowledge_base'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_rerun_knowledge_base'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_crawled_pages'                  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_rerun_sources'                      => wp_create_nonce(self::ACTION_STRING),
            'seoaic_remove_sources'                     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_generate_ai_summary_content'        => wp_create_nonce(self::ACTION_STRING),

            'seoaic_get_promote_media_list'             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_send_to_promote'                    => wp_create_nonce(self::ACTION_STRING),

            'seoaic_get_seo_audit_data'                 => wp_create_nonce(self::ACTION_STRING),
            'seoaic_create_seo_audit'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_page_speed_analysis'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_lighthouse_dates_html'          => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_all_site_links'                 => wp_create_nonce(self::ACTION_STRING),

            'seoaic_dashboard_counters'                 => wp_create_nonce(self::ACTION_STRING),
            'seoaic_dashboard_leads_export'             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_dashboard_get_keywords_table'       => wp_create_nonce(self::ACTION_STRING),
            'seoaic_dashboard_get_pages_table'          => wp_create_nonce(self::ACTION_STRING),

            'seoaic_activate_pillar_links'              => wp_create_nonce(self::ACTION_STRING),
            'seoaic_pillar_links_tracked'               => wp_create_nonce(self::ACTION_STRING),

            'seoaic_get_keywords_results'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_questions_words'                => wp_create_nonce(self::ACTION_STRING),

            // 'seoaicAddSearchTerms'                      => wp_create_nonce(self::ACTION_STRING),
            'seoaicRemoveSearchTerms'                   => wp_create_nonce(self::ACTION_STRING), // ???
            'seoaicGetKeywordSuggestions'               => wp_create_nonce(self::ACTION_STRING), // ???
            // 'seoaicAddSubTerms'                         => wp_create_nonce(self::ACTION_STRING),
            // 'seoaic_generate_post'                      => wp_create_nonce(self::ACTION_STRING),
            // 'seoaic_Get_on_page_seo_data'               => wp_create_nonce(self::ACTION_STRING),
            // 'seoaic_Get_My_Rank_Search_Term'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_Generate_Article_Based_Search_Term' => wp_create_nonce(self::ACTION_STRING), // ???
            // 'seoaicAddCompetitorsTerms'                 => wp_create_nonce(self::ACTION_STRING),
            // 'seoaicFilteringTerms'                      => wp_create_nonce(self::ACTION_STRING),
            'seoaic_compare_competitors_term'           => wp_create_nonce(self::ACTION_STRING), // ???
            'seoaic_get_calendar_draft_posts'           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_calendar_scheduled_posts'       => wp_create_nonce(self::ACTION_STRING),
            // 'seoaic_update_calendar_posts'              => wp_create_nonce(self::ACTION_STRING),
            // 'seoaic_custom_content_improvement'         => wp_create_nonce(self::ACTION_STRING),
            'seoaic_automated_improvement_run'          => wp_create_nonce(self::ACTION_STRING),
            'seoaic_automated_improvement_check_status' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_automated_improvement_stop_polling' => wp_create_nonce(self::ACTION_STRING),
            'seoaic_automated_improvement_republish'    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_proccess_onboarding_step'           => wp_create_nonce(self::ACTION_STRING), // ???

            'seoaic_get_lead_forms'                     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_add_lead_form_to_post'              => wp_create_nonce(self::ACTION_STRING),

            // SEA AJAX NONCE ACTIONS
            'seoaic_get_sea_campaigns'                  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_athorize'                       => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_ad_copy'                        => wp_create_nonce(self::ACTION_STRING),
            'seoaic_campaign_change_status'             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_get_performance'                => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_create_campaign'                => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_edit_campaign'                  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_get_campaign'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_sea_accounts'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_set_account'                    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_sea_campaign_group'             => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_ad_group_change_status'         => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_get_site_performance'           => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_log_out'                        => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_get_currency_symbol'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_set_settings'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_get_settings'                   => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_search_locations'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_create_ad_copy'                 => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_get_campaigns_stats'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sea_refresh_ad_group'               => wp_create_nonce(self::ACTION_STRING),

            'seoaic_generate_faq'                       => wp_create_nonce(self::ACTION_STRING),
            'seoaic_generate_faq_check_status'          => wp_create_nonce(self::ACTION_STRING),
            'seoaic_generate_faq_stop'                  => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_keywords'                       => wp_create_nonce(self::ACTION_STRING),
            'seoaic_analyze_prompts'                    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_prompts'                        => wp_create_nonce(self::ACTION_STRING),
            'seoaic_create_prompts'                     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_create_manual_prompts'              => wp_create_nonce(self::ACTION_STRING),
            'seoaic_update_prompts'                     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_remove_prompts'                     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_update_competitors'                 => wp_create_nonce(self::ACTION_STRING),
            'seoaic_remove_competitors'                 => wp_create_nonce(self::ACTION_STRING),
            'seoaic_request_providers'                  => wp_create_nonce(self::ACTION_STRING),

            'seoaic_sentiment_analysis_result'          => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sentiment_analysis_refresh'         => wp_create_nonce(self::ACTION_STRING),
            'seoaic_sentiment_analysis_request'         => wp_create_nonce(self::ACTION_STRING),

            'seoaic_create_also_ask_html'               => wp_create_nonce(self::ACTION_STRING),

            'seoaic_create_cluster_transition_queue'    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_settings_save_description'          => wp_create_nonce(self::ACTION_STRING),
            'seoaic_update_industry'                    => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_all_posts_clusters_batched'     => wp_create_nonce(self::ACTION_STRING),
            'seoaic_cluster_pages_and_ideas'            => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_clusters_options'               => wp_create_nonce(self::ACTION_STRING),
            'seoaic_get_data_for_individual_page_chart' => wp_create_nonce(self::ACTION_STRING),
        ];

        return $nonce_actions;
    }

    public function seoaicAdminNonceParams()
    {
        wp_localize_script( 'seoaic_admin_main_js', 'wp_nonce_params', $this->ajaxNonceActionsNew());
    }

    public function seoaicGutenbergNonceParams()
    {
        wp_localize_script('seoaic_gutenberg_js', 'wp_nonce_params', $this->ajaxNonceActionsNew());
    }
}
