<?php

namespace SEOAIC\rest_api\http_resources;

class Result
{
    private $success;
    private $statusCode;
    private $code;
    private $message;
    private $data;

    public function __construct($success, $statusCode, $code, $message, $data = [])
    {
        $this->success = $success;
        $this->statusCode = $statusCode;
        $this->code = $code;
        $this->message = $message;
        $this->data = $data;
    }

    public function toArray()
    {
        return [
            'success' => $this->success,
            'statusCode' => $this->statusCode,
            'code' => $this->code,
            'message' => $this->message,
            'data' => $this->data
        ];
    }

    public static function success($code, $message, $data)
    {
        $o = new self(true, 200, $code, $message, $data);
        return $o->toArray();
    }

    public static function error($code, $message)
    {
        $o = new self(false, 400, $code, $message);
        return $o->toArray();
    }
}
