<?php

namespace SEOAIC\rest_api;

use WP_REST_Request;

abstract class AbstractAPI
{
    public const SEOAIC_REST_API_ACTION = 'wp_rest';

    public function validateNonce(WP_REST_Request $request)
    {
        $nonce = $request->get_header('x_wp_nonce');
        $nonce = $nonce ?: '';

        return wp_verify_nonce($nonce, self::SEOAIC_REST_API_ACTION);
    }

    public function recursiveSanitizeTextField($array) {

        foreach ($array as $key => &$value) {
            if (is_array($value)) {
                $value = $this->recursiveSanitizeTextField($value);

            } else if (is_object($value)) {
                $value = $this->recursiveSanitizeTextField((array)$value);

            } else {
                $value = sanitize_text_field($value);
            }
        }

        return $array;
    }
}
