<?php

namespace SEOAIC\resources;

use WP_Post;

class PillarLink
{
    public $id;
    public $url;
    public $title;
    public $lang;
    public $locale;

    // private function setURL(string $url)
    // {
    //     $this->url = $url;
    // }

    // private function setTitle(string $title)
    // {
    //     $this->title = $title;
    // }

    public static function fromWP_Post(WP_Post $post)
    {
        global $SEOAIC;

        $pillarLink = new self();
        $pillarLink->id = $post->ID;
        $pillarLink->url = get_permalink($post->ID);
        $pillarLink->title = get_the_title($post->ID);
        if ($SEOAIC->multilang->is_multilang()) {
            $pillarLink->lang = $SEOAIC->multilang->get_post_language($post->ID, 'code');
            $pillarLink->locale = $SEOAIC->multilang->get_post_language($post->ID, 'locale');
        }

        return $pillarLink;
    }

    public static function fromString(string $link)
    {
        $pillarLink = new self();
        $pillarLink->url = $link;

        return $pillarLink;
    }
}
