<?php

namespace SEOAIC\resources;

class Lead
{
    public int $id;
    public string $status;
    public string $emailStatus;
    public string $data;
    public string $date;
    public string $pageUrl;
    public string $pageTitle;

    public function __construct() {
        $this->date = time();
    }

    public static function fromRESTRequest($data)
    {
        $lead = new self();
        $lead->status = !empty($data->status) ? $data->status : 'initiated';
        $lead->data = !empty($data->data) ? $data->data : [];

        return $lead;
    }

    public static function fromDBRecord($data)
    {
        $lead = new self();

        foreach ($data as $key => $value) {
            $keyWords = explode('_', $key);
            $words = array_map('ucfirst', $keyWords);
            $keyWord = implode('', $words);
            $keyWord = lcfirst($keyWord);
            $lead->$keyWord = $value;
        }

        return $lead;
    }

    public function toArray()
    {
        return [
            'id'        => !empty($this->id) ? $this->id : null,
            'status'    => !empty($this->status) ? $this->status : null,
            'data'      => !empty($this->data) ? $this->data : '',
            'date'      => !empty($this->date) ? wp_date('Y-m-d H:i:s', $this->date) : null,
            'page_url'  => !empty($this->pageUrl) ? $this->pageUrl : '',
            'page_title' => !empty($this->pageTitle) ? $this->pageTitle : '',
        ];
    }
}
