<?php

namespace SEOAIC\repositories;

use SEOAIC\DB\LeadAddonTable;
use SEOAIC\resources\Lead;
use SEOAIC\SeoaicLeadsAddon;
use SEOAIC\traits\WPDB;
use stdClass;

class LeadAddonRepository
{
    use WPDB;

    private $leadAddonTable;

    public function __construct()
    {
        $this->leadAddonTable = new LeadAddonTable();
    }

    public function getAll()
    {
        return $this->leadAddonTable->getAllData();
    }

    public function getById(int $id): Lead
    {
        $record = $this->leadAddonTable->getById($id);
        $lead = Lead::fromDBRecord($record);

        return $lead;
    }

    public function getCaptured()
    {
        $records = $this->leadAddonTable->getByField('status', SeoaicLeadsAddon::LEAD_CAPTURED_STATUS);

        return $records;
    }

    public function create(Lead $lead)
    {
        $this->leadAddonTable::createIfNotExists();

        $data = $lead->toArray();

        return $this->leadAddonTable->insertData($data);
    }

    public function update(int $id, array $data)
    {
        $this->leadAddonTable::createIfNotExists();

        return $this->leadAddonTable->updateData($data, ['id' => $id]);
    }
}