<?php

namespace SEOAIC\repositories;

use SEOAIC\DB\InteractiveArticleAddonTable;
use SEOAIC\DB\LeadAddonTable;
use SEOAIC\resources\InteractiveArticleResource;
use SEOAIC\resources\Lead;
use SEOAIC\traits\WPDB;

class InteractiveArticleAddonRepository
{
    use WPDB;

    private $interactiveArticleTable;

    public function __construct()
    {
        $this->interactiveArticleTable = new InteractiveArticleAddonTable();
    }

    // public function getAll()
    // {
    //     return $this->leadAddonTable->getAllData();
    // }

    public function getById(int $id): InteractiveArticleResource
    {
        $record = $this->interactiveArticleTable->getById($id);
        $interactiveArticle = InteractiveArticleResource::fromDBRecord($record);

        return $interactiveArticle;
    }

    public function getByPostId($value): array
    {
        $records = $this->interactiveArticleTable->getByField('post_id', $value);

        return $records;
    }

    public function create(InteractiveArticleResource $interactiveArticleResource)
    {
        $this->interactiveArticleTable::createIfNotExists();

        $data = $interactiveArticleResource->toArray();

        return $this->interactiveArticleTable->insertData($data);
    }

    public function update(int $id, array $data)
    {
        $this->interactiveArticleTable::createIfNotExists();

        return $this->interactiveArticleTable->updateData($data, ['id' => $id]);
    }

    public function deleteByPostId(int $id)
    {
        $records = $this->interactiveArticleTable->deleteByField(['post_id' => $id]);

        return $records;
    }
}