<?php

namespace SEOAIC\preset_types;

class ReplaceLink extends AbstractPresetType
{
    public $name = 'replace_links';
    public $preselectDefault = false;

    public function getTitle() {
        return esc_html__('Replace Links', 'seoaic');
    }

    public function drawHtml() {
        echo '<label for="">' . esc_html($this->getTitle()) . '</label><div id="mass-edit_replace-link"></div>';
    }

    public function makePayload() {
        $__REQUEST = wp_unslash($_REQUEST);
        $dataLinks = !empty($__REQUEST['seoaic_posts_mass_replacement']) ? $__REQUEST['seoaic_posts_mass_replacement'] : [];

        if (is_string($dataLinks)) {
            $dataLinks = json_decode($dataLinks, true);
        }

        $links = [];

        foreach ($dataLinks as $item) {
            $links[] = [
                'url'       => esc_url_raw($item['url']),
                'new_url'   => esc_url_raw($item['new_url']),
                'new_title' => sanitize_text_field($item['new_title']),
            ];
        }

        return [
            'links' => $links
        ];
    }
}
