<?php

namespace SEOAIC\preset_types;

class CustomPrompt extends AbstractPresetType
{
    public $name = 'custom_prompt';
    public $preselectDefault = true;

    public function getTitle() {
        return esc_html__('Custom prompt', 'seoaic');
    }

    public function drawHtml() {
        echo '<label for="posts_edit_mass_prompt">' . esc_html($this->getTitle()) . '</label>
            <div class="seoaic-popup__field">
                <textarea name="mass_prompt" id="posts_edit_mass_prompt" class="seoaic-form-item mt-0"></textarea>
            </div>';
    }

    public function makePayload() {
        $__REQUEST = wp_unslash($_REQUEST);
        $prompt = !empty($__REQUEST['mass_prompt']) ? $__REQUEST['mass_prompt'] : '';

        return [
            'prompt' => $prompt
        ];
    }
}
