<?php

namespace SEOAIC\preset_types;

abstract class AbstractPresetType
{
    public $name;
    public $preselectDefault;
    public $separator = '___SEP___';

    abstract protected function getTitle();
    abstract protected function drawHtml();
    abstract protected function makePayload();

    public function getName() {
        return $this->name;
    }

    public function makePresetRadio() {
        $html = '<div class="wrapper d-flex">
                    <div class="checkbox-wrapper-mc">
                        <input id="presets-'.$this->name.'"
                            class="seoaic-form-item preset-radio"
                            name="seoaic_presets" type="radio"
                            value="'.$this->name.'"
                            '.($this->preselectDefault ? 'checked' : '').'>
                        <label for="presets-'.$this->name.'" class="check">
                            <svg width="18px" height="18px" viewBox="0 0 18 18">
                                <path d="M1,9 L1,3.5 C1,2 2,1 3.5,1 L14.5,1 C16,1 17,2 17,3.5 L17,14.5 C17,16 16,17 14.5,17 L3.5,17 C2,17 1,16 1,14.5 L1,9 Z"></path>
                                <polyline points="1 9 7 14 15 4"></polyline>
                            </svg>
                            <span>'.$this->getTitle().'</span>
                        </label>
                    </div>
                </div>';

        return $html;
    }

    public function makePresetCheckbox() {
        $html = '<div class="wrapper d-flex">
                    <div class="checkbox-wrapper-mc">
                        <input id="presets-'.$this->name.'"
                            class="seoaic-form-item preset-radio"
                            name="seoaic_presets[]"
                            type="checkbox"
                            value="'.$this->name.'"
                            '.($this->preselectDefault ? 'checked' : '').'>
                        <label for="presets-'.$this->name.'" class="check">
                            <svg width="18px" height="18px" viewBox="0 0 18 18">
                                <path d="M1,9 L1,3.5 C1,2 2,1 3.5,1 L14.5,1 C16,1 17,2 17,3.5 L17,14.5 C17,16 16,17 14.5,17 L3.5,17 C2,17 1,16 1,14.5 L1,9 Z"></path>
                                <polyline points="1 9 7 14 15 4"></polyline>
                            </svg>
                            <span>'.$this->getTitle().'</span>
                        </label>
                    </div>
                </div>';

        return $html;
    }
}
