<?php

namespace SEOAIC\keyword_types;

use SEOAIC\interfaces\KeywordTypeInterface;

abstract class KeywordBaseType implements KeywordTypeInterface
{
    protected $name;
    protected $title;
    protected $dataAttrs = [];

    public function getName(): string
    {
        return $this->name;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getDataAttrs(): array
    {
        return $this->dataAttrs;
    }

    public function makeOptionTag(): string
    {
        return '<option value="' . esc_attr($this->name) . '">' . esc_html($this->title) . '</option>';
    }

    public function makeRadioTag($checked = false): string
    {
        $attrs = '';
        $dataAttrs = $this->getDataAttrs();
        if (!empty($dataAttrs)) {
            foreach ($dataAttrs as $key => $value) {
                $attrs .= 'data-' . esc_attr($key) . '="' . esc_attr($value) . '" ';
            }
        }

        return '<label class="radio">
            <input type="radio" name="keyword_type" value="' . esc_attr($this->name) . '"' . ($checked ? ' checked=""' : '') . ' class="seoaic-form-item ' . esc_attr($this->name) . '-radio" ' . trim($attrs) . '>
            <span class="name">' . esc_html($this->title) . '</span>
        </label>';
    }
}
