<?php

namespace SEOAIC\helpers;

class WPTransients
{
    public static function getCachedValue(string $name)
    {
        return get_transient($name);
    }

    /**
     * @param string $transient Transient name. Expected to not be SQL-escaped. Must be 172 characters or fewer in length.
     * @param mixed $value Transient value. Must be serializable if non-scalar. Expected to not be SQL-escaped.
     * @param int $expiration Optional. Time until expiration in seconds. Default 0 (no expiration).
     * @return bool — True if the value was set, false otherwise.
     */
    public static function cacheValue(string $name, $value, int $expiration = 0): bool
    {
        return set_transient($name, $value, $expiration);
    }

    public static function deleteCachedValue(string $name): bool
    {
        $delete = delete_transient($name);

        if (is_null($delete)) {
            return false;
        }

        return (bool) $delete;
    }
}
