<?php

namespace SEOAIC\helpers;

use SEOAIC\thirdparty_plugins_meta_tags\AIOSEOMetaTags;
use SEOAIC\thirdparty_plugins_meta_tags\RankMathMetaTags;
use SEOAIC\thirdparty_plugins_meta_tags\SEOPressMetaTags;
use SEOAIC\thirdparty_plugins_meta_tags\YoastMetaTags;

class SEOPluginsHelper
{
    public $plugins = [];

    public function __construct()
    {
        $this->plugins = [
            new YoastMetaTags(),
            new RankMathMetaTags(),
            new AIOSEOMetaTags(),
            new SEOPressMetaTags(),
        ];
    }

    /**
     * Gets first available external SEO plugin
     * @return object|null instanse of the first available class, or null if there is no activated plugins
     */
    public static function getAvailableSEOPlugin()
    {
        $self = new self();

        foreach ($self->plugins as $instance) {
            if ($instance->isPluginActive()) {
                return $instance;
            }
        }

        return null;
    }

    /**
     * Gets all available external SEO plugins
     * @return array Array of instanses of the all available classes
     */
    public static function getAllSEOPlugins(): array
    {
        $self = new self();

        return $self->plugins;
    }
}
